/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.policy.io.jsonp;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.Unmodifiable;
import com.covisint.platform.authn.core.password.policy.AbstractPolicyRule;
import com.covisint.platform.authn.core.password.policy.PasswordPolicy;
import com.covisint.platform.authn.core.password.policy.io.jsonp.AbstractPasswordPolicyRuleWriter;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class PasswordPolicyWriter
extends AbstractRealmScopedResourceWriter<PasswordPolicy> {
    private Map<String, AbstractPasswordPolicyRuleWriter> ruleCodecs = Collections.EMPTY_MAP;

    @Nonnull
    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull PasswordPolicy passwordPolicy) {
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractRealmScopedResource)passwordPolicy);
        if (passwordPolicy.getStatus() != null) {
            builder.add("status", passwordPolicy.getStatus().toString());
        }
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"name", (String)passwordPolicy.getName());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)builder, (String)"description", (String)passwordPolicy.getDescription());
        if (passwordPolicy.getRules().size() > 0) {
            JsonArrayBuilder rulesJson = Json.createArrayBuilder();
            for (AbstractPolicyRule rule : passwordPolicy.getRules().values()) {
                AbstractPasswordPolicyRuleWriter ruleCodec = this.ruleCodecs.get(rule.getType().toLowerCase());
                if (ruleCodec == null) {
                    throw new EntityWriterException("Rule of type " + rule.getType().toLowerCase() + " does not have a registered codec");
                }
                rulesJson.add(ruleCodec.write(rule));
            }
            builder.add("rules", rulesJson);
        }
        return builder;
    }

    @Nonnull
    public Class<PasswordPolicy> getResourceType() {
        return PasswordPolicy.class;
    }

    @Unmodifiable
    @Nonnull
    @NonnullElements
    public Collection<AbstractPasswordPolicyRuleWriter> getPasswordPolicyRuleCodecs() {
        return Collections.unmodifiableCollection(this.ruleCodecs.values());
    }

    public void setPasswordPolicyRuleCodecs(Collection<AbstractPasswordPolicyRuleWriter> codecs) {
        if (codecs == null) {
            return;
        }
        this.ruleCodecs = new HashMap<String, AbstractPasswordPolicyRuleWriter>();
        for (AbstractPasswordPolicyRuleWriter codec : codecs) {
            if (codec == null) continue;
            this.ruleCodecs.put(codec.getRuleType().toLowerCase(), codec);
        }
    }

    public boolean isWritable(@Nonnull Class klass, @Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_POLICY_MT, mediaType);
    }
}

