/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.password.validation.io.jsonp;

import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.password.validation.PasswordValidationResponse;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.base.Charsets;
import com.google.common.net.MediaType;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyValidationResponseWriter
implements EntityWriter<PasswordValidationResponse> {
    private final Logger log = LoggerFactory.getLogger(PolicyValidationResponseWriter.class);

    @Nonnull
    public Class<PasswordValidationResponse> getResourceType() {
        return PasswordValidationResponse.class;
    }

    public boolean isWritable(@Nonnull Class<?> clazz, @Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PASSWORD_VALIDATION_RESPONSE_MT, mediaType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaType write(@Nonnull MediaType mediaType, @Nonnull PasswordValidationResponse source, @Nonnull OutputStream output) {
        JsonWriterFactory jsonFactory = Json.createWriterFactory(new HashMap());
        if (!this.getResourceType().isAssignableFrom(source.getClass())) {
            throw new EntityWriterException("The server is unable to produce content of type");
        }
        List<PasswordValidationResponse.RuleValidation> ruleValidations = source.getRuleValidations();
        JsonArrayBuilder responsesJson = Json.createArrayBuilder();
        for (PasswordValidationResponse.RuleValidation validation : ruleValidations) {
            JsonObjectBuilder responseJson = Json.createObjectBuilder();
            responseJson.add("type", validation.getType());
            responseJson.add("desc", validation.getDescription());
            responseJson.add("isPassed", validation.isPassed());
            responsesJson.add(responseJson);
        }
        try (JsonWriter writer = jsonFactory.createWriter(output, Charsets.UTF_8);){
            this.log.debug("Writing JSON to output stream");
            writer.write((JsonStructure)responsesJson.build());
            MediaType mediaType2 = mediaType;
            return mediaType2;
        }
        catch (IllegalStateException | JsonException e) {
            this.log.debug("Unable to write JSON to output stream", e);
            throw new EntityWriterException("Unable to write JSON");
        }
    }
}

