/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.policy;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.authn.core.policy.AuthenticationPolicy;
import com.google.common.base.Objects;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class AbstractAuthenticationPolicyRule<T extends AbstractAuthenticationPolicyRule>
implements Serializable {
    private static final long serialVersionUID = -1796119616687123413L;
    @Id
    @Column(length=64, nullable=false)
    private String type;
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="POLICY_ID", nullable=false)
    private AuthenticationPolicy policy;

    final T setAuthenticationPolicy(AuthenticationPolicy authnPolicy) {
        this.policy = authnPolicy;
        return (T)this;
    }

    protected final Objects.ToStringHelper populateToStringHelper(Objects.ToStringHelper helper) {
        return helper.add("type", (Object)this.type).add("authnPolicyId", (Object)this.policy.getId());
    }

    protected T setType(@Nonnull @NotEmpty String ruleType) {
        this.type = ruleType;
        return (T)this;
    }

    @Nullable
    public final String getType() {
        return this.type;
    }

    @Nullable
    public final AuthenticationPolicy getAuthenticationPolicy() {
        return this.policy;
    }

    public final int hashCode() {
        if (this.policy == null) {
            return Objects.hashCode((Object[])new Object[]{this.type, (short)Short.MAX_VALUE});
        }
        return Objects.hashCode((Object[])new Object[]{this.type, this.policy.getId()});
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractAuthenticationPolicyRule)) {
            return false;
        }
        AbstractAuthenticationPolicyRule other = (AbstractAuthenticationPolicyRule)obj;
        return Objects.equal((Object)this.getType(), (Object)other.getType()) && Objects.equal((Object)((Object)this.getAuthenticationPolicy()), (Object)((Object)other.getAuthenticationPolicy()));
    }
}

