/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.policy;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Unmodifiable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.authn.core.policy.AbstractAuthenticationPolicyRule;
import com.covisint.platform.authn.core.policy.AuthenticationPolicyStatus;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="AUTHN_POLICY")
@NamedQueries(value={@NamedQuery(name="authenticationPolicy.findByName", query="SELECT p FROM AuthenticationPolicy p where  p.name = :name and p.realm = :realm")})
public class AuthenticationPolicy
extends AbstractRealmScopedResource<AuthenticationPolicy> {
    private static final long serialVersionUID = 2195154040515649065L;
    @Column(name="STATUS", nullable=false, length=16)
    @Enumerated(value=EnumType.STRING)
    private AuthenticationPolicyStatus status;
    @Column(name="NAME", nullable=false, length=64)
    private String name;
    @Column(name="DESCRIPTION", nullable=true, length=1024)
    private String description;
    @OneToMany(mappedBy="policy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @MapKey(name="type")
    private Map<String, AbstractAuthenticationPolicyRule> rules = new HashMap<String, AbstractAuthenticationPolicyRule>();

    @Nullable
    public AuthenticationPolicyStatus getStatus() {
        return this.status;
    }

    public AuthenticationPolicy setStatus(@Nonnull AuthenticationPolicyStatus policyStatus) {
        this.status = policyStatus;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public AuthenticationPolicy setName(@Nonnull @NotEmpty String policyName) {
        this.name = policyName;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public AuthenticationPolicy setDescription(@Nullable String policyDescription) {
        this.description = StringSupport.trimOrNull((String)policyDescription);
        return this;
    }

    @Unmodifiable
    @Nullable
    public Map<String, AbstractAuthenticationPolicyRule> getRules() {
        return ImmutableMap.copyOf(this.rules);
    }

    public AbstractAuthenticationPolicyRule addRule(@Nullable AbstractAuthenticationPolicyRule rule) {
        if (rule == null) {
            return null;
        }
        AuthenticationPolicy currentPolicy = rule.getAuthenticationPolicy();
        if (currentPolicy != null) {
            currentPolicy.removeRule(rule);
        }
        rule.setAuthenticationPolicy(this);
        AbstractAuthenticationPolicyRule replacedRule = this.rules.put(rule.getType(), rule);
        if (replacedRule != null) {
            replacedRule.setAuthenticationPolicy(null);
        }
        return replacedRule;
    }

    public AbstractAuthenticationPolicyRule removeRule(@Nullable AbstractAuthenticationPolicyRule rule) {
        if (rule == null) {
            return null;
        }
        return this.removeRule(rule.getType());
    }

    public AbstractAuthenticationPolicyRule removeRule(@Nullable String ruleType) {
        String trimmedType = StringSupport.trimOrNull((String)ruleType);
        if (trimmedType == null) {
            return null;
        }
        AbstractAuthenticationPolicyRule removedRule = this.rules.remove(ruleType);
        if (removedRule != null) {
            removedRule.setAuthenticationPolicy(null);
        }
        return removedRule;
    }

    public int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public boolean equals(Object obj) {
        return this.isResourceIdentityEqual(AuthenticationPolicy.class, obj);
    }

    public String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("name", (Object)this.name).add("description", (Object)this.description).add("status", (Object)this.status).add("rules", this.rules.values()).toString();
    }
}

