/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.securityquestion;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SecurityQuestion
extends AbstractRealmScopedResource<SecurityQuestion> {
    private static final long serialVersionUID = 332682303092812341L;
    private ResourceReference owner;
    private Map<String, String> question;

    @Nullable
    public final ResourceReference getOwner() {
        return this.owner;
    }

    @Nonnull
    public final SecurityQuestion setOwner(@Nonnull ResourceReference newOwner) {
        this.owner = newOwner;
        return this;
    }

    @Nonnull
    public final SecurityQuestion setOwningPersonId(@Nonnull @NotEmpty String personId) {
        this.owner = new ResourceReference(personId, "person");
        return this;
    }

    @Nullable
    public final Map<String, String> getQuestion() {
        if (this.question == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.question);
    }

    @Nonnull
    public final SecurityQuestion setQuestion(@Nonnull Map<String, String> newQuestion) {
        this.question = new HashMap<String, String>(newQuestion);
        return this;
    }

    @Nonnull
    @NotEmpty
    public final String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("question", this.getQuestion()).add("owner", (Object)this.getOwner()).toString();
    }

    public final int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public final boolean equals(Object obj) {
        return this.isResourceIdentityEqual(SecurityQuestion.class, obj);
    }
}

