/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.userpin.io.jsonp;

import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.platform.authn.core.userpin.Pin;
import com.covisint.platform.authn.core.util.JsonpSupport;
import com.covisint.platform.authn.core.util.SupportedMediaType;
import com.google.common.net.MediaType;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinReader
extends AbstractRealmScopedResourceReader<Pin> {
    private final Logger log = LoggerFactory.getLogger(PinReader.class);

    @Nonnull
    protected Pin readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        Pin pin = (Pin)super.readResource(mediaType, json);
        this.log.debug("About to unmarshall the following JSON representation: {}", (Object)json.toString());
        JsonString stringProperty = json.getJsonString("pin");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            pin.setPin(stringProperty.getString());
        }
        return pin;
    }

    @Nonnull
    protected Pin createResource(@Nonnull MediaType mediaType) {
        return new Pin();
    }

    @Nonnull
    public Class<Pin> getResourceType() {
        return Pin.class;
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.PIN_MT, mediaType);
    }
}

