/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.authn.core.util;

import com.covisint.core.support.constraint.ConstraintViolationException;
import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageManager.class);
    private static final String LANGUAGE_PROP = "languageLabel.txt";
    private static final String SPLIT_PROP = "\\t";
    private static final Map<String, Map<String, String>> MESSAGESMAP = LanguageManager.initialMessageMap();
    public static final String LANGUAGE_TAG_ENGLISH = "en";
    public static final List<String> LANGUAGE_TAGS_ENGLISH_ONLY = new ImmutableList.Builder().add((Object)"en").build();

    private LanguageManager() {
    }

    private static Map<String, Map<String, String>> initialMessageMap() {
        LOGGER.debug("initialMessageMap starting... ");
        HashMap<String, Map<String, String>> multilingualMap = new HashMap<String, Map<String, String>>();
        try {
            ArrayList<String> lines = new ArrayList<String>();
            InputStream inputStream = LanguageManager.class.getClassLoader().getResourceAsStream(LANGUAGE_PROP);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String value = null;
                while ((value = br.readLine()) != null) {
                    lines.add(value);
                }
            }
            for (String line : lines) {
                String[] langArray = line.split(SPLIT_PROP);
                if (langArray.length == 3) {
                    Map<String, String> valueMap;
                    String name = langArray[0].trim();
                    String tag = langArray[1].trim();
                    String message = langArray[2];
                    if (!multilingualMap.containsKey(name)) {
                        valueMap = Maps.newHashMap();
                        valueMap.put(tag, message);
                        multilingualMap.put(name, valueMap);
                        continue;
                    }
                    valueMap = (Map)multilingualMap.get(name);
                    valueMap.put(tag, message);
                    continue;
                }
                LOGGER.error("Data file format is not correct, the error data is " + line);
                throw new ConstraintViolationException("Data file format is not correct, the error data is " + line);
            }
        }
        catch (IOException e) {
            LOGGER.error("Processing parsing data file error : {}", (Throwable)e);
        }
        LOGGER.debug("initialMessageMap validate language .... ");
        LanguageManager.validate(multilingualMap);
        LOGGER.debug("initialMessageMap end .... ");
        return Collections.unmodifiableMap(multilingualMap);
    }

    private static void validate(Map<String, Map<String, String>> tarMessageMap) {
        for (Map.Entry<String, Map<String, String>> entry : tarMessageMap.entrySet()) {
            Map<String, String> tagMap = entry.getValue();
            if (tagMap.containsKey(LANGUAGE_TAG_ENGLISH)) continue;
            throw new ConstraintViolationException("Language label " + entry.getKey() + " must have an English version message.");
        }
    }

    @Nonnull
    public static String getText(@Nonnull String name, @Nonnull List<String> languageTags) {
        LOGGER.debug("getText name [" + name + "], languageTags " + languageTags);
        Map<String, String> msgMap = MESSAGESMAP.get(name);
        LOGGER.debug("getText msgMap [" + name + "] value " + msgMap);
        Constraints.isNotNull(msgMap, (String)("Language label " + name + " not found."));
        for (String tag : languageTags) {
            if (!msgMap.containsKey(tag)) continue;
            String returnValue = msgMap.get(tag);
            LOGGER.debug("getText return value " + returnValue);
            return returnValue;
        }
        String label = msgMap.get(LANGUAGE_TAG_ENGLISH);
        LOGGER.debug("getText default value " + label);
        return label;
    }
}

