/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.token.sdk;

import com.covisint.core.http.service.client.BaseResourceClientFactory;
import com.covisint.core.http.service.client.ClientInitializationContext;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.BasicAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.SwappableCredentialSupport;
import com.covisint.platform.oauth.client.token.sdk.TokenSDK;
import com.covisint.platform.oauth.core.token.Token;
import com.google.common.base.Supplier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenSupplier
implements SwappableCredentialSupport,
Supplier<String> {
    private static final long EXPIRATION_ADVANCE_REFRESH_MILLIS = 60000L;
    private static final long DEFAULT_REFRESH_DELAY = 900000L;
    private static final String TIMER_NAME = "Access Token Refresher";
    private final Logger log = LoggerFactory.getLogger(TokenSupplier.class);
    private final TokenSDK.TokenClient tokenClient;
    private final Timer timer;
    private final URL authServiceBaseUrl;
    private AuthConfigurationProvider authConfigurationProvider;
    private Token token;

    public TokenSupplier(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigurationProvider = provider;
        this.timer = new Timer(TIMER_NAME, true);
        String authUrl = provider.getAuthServiceBaseUrl().toString();
        BaseResourceClientFactory clientFactory = ClientInitializationContext.getClientFactory();
        TokenSDK tokenSdk = new TokenSDK(authUrl);
        tokenSdk.setAuthConfigProvider(provider);
        if (clientFactory != null) {
            this.copyConfig(tokenSdk, clientFactory);
        }
        this.tokenClient = tokenSdk.newClient();
        try {
            this.authServiceBaseUrl = new URL(authUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Bad auth service URL", e);
        }
        this.refreshToken();
    }

    private void copyConfig(@Nonnull BaseResourceClientFactory target, @Nonnull BaseResourceClientFactory source) {
        if (source.getHttpProxySpec() != null) {
            target.setHttpProxySpec(source.getHttpProxySpec());
        }
        if (source.getSourceAddress() != null) {
            target.setSourceAddress(source.getSourceAddress());
        }
        if (source.getContentCompressionEnabled() != null) {
            target.setContentCompressionEnabled(source.getContentCompressionEnabled());
        }
        if (source.getConnectionTimeout() != null) {
            target.setConnectionTimeout(source.getConnectionTimeout());
        }
        if (source.getSocketTimeout() != null) {
            target.setSocketTimeout(source.getSocketTimeout());
        }
        if (source.getContentCharSet() != null) {
            target.setContentCharSet(source.getContentCharSet());
        }
    }

    private void refreshToken() {
        String clientId = this.authConfigurationProvider.getClientId();
        String clientSecret = this.authConfigurationProvider.getClientSecret();
        this.log.debug("Fetching new token for client id {}", (Object)clientId);
        this.token = (Token)this.tokenClient.getToken(clientId, clientSecret).checkedGet();
        this.scheduleNextRefresh();
    }

    private void scheduleNextRefresh() {
        long refreshDelay = this.token.getExpirationTime() - System.currentTimeMillis() - 60000L;
        if (refreshDelay < 60000L) {
            this.log.warn("Invalid refresh delay: {}.  Using default: {}", (Object)refreshDelay, (Object)900000L);
            refreshDelay = 900000L;
        }
        this.timer.schedule((TimerTask)new TokenRefresher(), refreshDelay);
    }

    public String get() {
        return this.token.getEncodedToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapCredentials(@Nonnull @NotEmpty String clientId, @Nonnull @NotEmpty String secret, String appId) {
        AuthConfigurationProvider authConfigurationProvider = this.authConfigurationProvider;
        synchronized (authConfigurationProvider) {
            this.authConfigurationProvider = new BasicAuthConfigurationProvider(clientId, secret, appId, this.authServiceBaseUrl);
        }
    }

    private final class TokenRefresher
    extends TimerTask {
        private TokenRefresher() {
        }

        @Override
        public void run() {
            TokenSupplier.this.refreshToken();
        }
    }
}

