/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.support.httpclient;

import com.covisint.core.support.aspect.NonnullValidator;
import com.covisint.core.support.aspect.NotEmptyValidator;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.trace.Span;
import com.covisint.core.trace.SpanHolder;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpanInterceptor
implements HttpRequestInterceptor {
    private final Logger log;
    private final String traceIdHeaderName;
    private final String spanIdHeaderName;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public SpanInterceptor() {
        this("X-Trace", "X-Span");
    }

    public SpanInterceptor(@Nonnull @NotEmpty String newTraceIdHeaderName, @Nonnull @NotEmpty String newSpanIdHeaderName) {
        String string = newSpanIdHeaderName;
        String string2 = newTraceIdHeaderName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2, (Object)string);
        NotEmptyValidator.aspectOf().validateConstructorArg1((Object)string2, joinPoint);
        NotEmptyValidator.aspectOf().validateConstructorArg2((Object)string, joinPoint);
        NonnullValidator.aspectOf().validateConstructorArg1((Object)string2, joinPoint);
        NonnullValidator.aspectOf().validateConstructorArg2((Object)string, joinPoint);
        this.log = LoggerFactory.getLogger(SpanInterceptor.class);
        this.traceIdHeaderName = newTraceIdHeaderName;
        this.spanIdHeaderName = newSpanIdHeaderName;
    }

    public void process(@Nonnull HttpRequest request, @Nonnull HttpContext context) throws HttpException, IOException {
        HttpContext httpContext = context;
        HttpRequest httpRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)httpRequest, (Object)httpContext);
        NonnullValidator.aspectOf().validateMethodArg1((Object)httpRequest, joinPoint);
        NonnullValidator.aspectOf().validateMethodArg2((Object)httpContext, joinPoint);
        Span span = SpanHolder.getCurrentSpan();
        if (span == null) {
            return;
        }
        request.addHeader(this.traceIdHeaderName, String.valueOf(span.getTraceId()));
        request.addHeader(this.spanIdHeaderName, String.valueOf(span.getSpanId()));
        this.log.debug("Wrote span out to request: {}", (Object)span);
    }

    static {
        SpanInterceptor.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpanInterceptor.java", SpanInterceptor.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.covisint.core.support.httpclient.SpanInterceptor", "java.lang.String:java.lang.String", "newTraceIdHeaderName:newSpanIdHeaderName", ""), 43);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "process", "com.covisint.core.support.httpclient.SpanInterceptor", "org.apache.http.HttpRequest:org.apache.http.protocol.HttpContext", "request:context", "org.apache.http.HttpException:java.io.IOException", "void"), 49);
    }
}

