/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.client.group;

import com.covisint.core.http.service.client.BaseResourceClientBuilder;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.group.client.group.GroupClientImpl;
import com.covisint.platform.group.core.group.io.SupportedMediaType;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import com.google.common.net.MediaType;

public class GroupClientBuilder
extends BaseResourceClientBuilder<GroupClientBuilder, GroupClientImpl> {
    private static final String RESOURCE_COLLECTION_PATH = "/groups";

    @Nonnull
    @NotEmpty
    protected final String getResourceCollectionPath() {
        return RESOURCE_COLLECTION_PATH;
    }

    @Nonnull
    protected final MediaType getResourceRepresentation() {
        return MediaType.parse((String)SupportedMediaType.GROUP_MT.value());
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getGroupByIdWithEntitlementsEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(RESOURCE_COLLECTION_PATH).path(new VarSpec[]{UriTemplateBuilder.var((String)"groupId")}).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating retrieval endpoint template", e);
        }
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getSearchGroupsWithEntitlementsEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(RESOURCE_COLLECTION_PATH).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating search endpoint template", e);
        }
    }

    @Nonnull
    public final GroupClientImpl build() {
        GroupClientImpl impl = (GroupClientImpl)this.populateBaseBuilder(new GroupClientImpl());
        impl.setGetByIdWithEntitlementsEndpointUriTemplate(this.getGroupByIdWithEntitlementsEndpoint());
        impl.setSearchGroupsWithEntitlementsEndpointUriTemplate(this.getSearchGroupsWithEntitlementsEndpoint());
        return impl;
    }
}

