/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.client.group.entitlement;

import com.covisint.core.http.service.client.BaseResourceClientBuilder;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.group.client.group.entitlement.GroupEntitlementClientImpl;
import com.covisint.platform.group.core.group.io.SupportedMediaType;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import com.google.common.net.MediaType;

public class GroupEntitlementClientBuilder
extends BaseResourceClientBuilder<GroupEntitlementClientBuilder, GroupEntitlementClientImpl> {
    private static final String RESOURCE_COLLECTION_PATH = "/";

    @Nonnull
    @NotEmpty
    protected final String getResourceCollectionPath() {
        return RESOURCE_COLLECTION_PATH;
    }

    @Nonnull
    protected final MediaType getResourceRepresentation() {
        return MediaType.parse((String)SupportedMediaType.GROUP_ENTITLEMENT_MT.value());
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getAddEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/groups").path(new VarSpec[]{UriTemplateBuilder.var((String)"groupId")}).literal("/entitlements").build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating add endpoint template", e);
        }
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getGetByIdEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/groups").path(new VarSpec[]{UriTemplateBuilder.var((String)"groupId")}).literal("/entitlements").path(new VarSpec[]{UriTemplateBuilder.var((String)"entitlementId")}).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating retrieval endpoint template", e);
        }
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getSearchEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/groups").path(new VarSpec[]{UriTemplateBuilder.var((String)"groupId")}).literal("/entitlements").build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating retrieval endpoint template", e);
        }
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getDeleteEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/groups").path(new VarSpec[]{UriTemplateBuilder.var((String)"groupId")}).literal("/entitlements").path(new VarSpec[]{UriTemplateBuilder.var((String)"entitlementId")}).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating modification endpoint template", e);
        }
    }

    @Nonnull
    public final GroupEntitlementClientImpl build() {
        GroupEntitlementClientImpl impl = (GroupEntitlementClientImpl)this.populateBaseBuilder(new GroupEntitlementClientImpl());
        impl.setAddUriTemplate(this.getAddEndpoint());
        impl.setGetByIdUriTemplate(this.getGetByIdEndpoint());
        impl.setSearchUriTemplate(this.getSearchEndpoint());
        impl.setDeleteUriTemplate(this.getDeleteEndpoint());
        return impl;
    }
}

