/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.client.group.membership;

import com.covisint.core.http.service.client.BaseResourceClientBuilder;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.group.client.group.membership.GroupMembershipClientImpl;
import com.covisint.platform.group.core.group.io.SupportedMediaType;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import com.google.common.net.MediaType;

public class GroupMembershipClientBuilder
extends BaseResourceClientBuilder<GroupMembershipClientBuilder, GroupMembershipClientImpl> {
    private static final String RESOURCE_COLLECTION_PATH = "/";

    @Nonnull
    @NotEmpty
    protected final String getResourceCollectionPath() {
        return RESOURCE_COLLECTION_PATH;
    }

    @Nonnull
    protected final MediaType getResourceRepresentation() {
        return MediaType.parse((String)SupportedMediaType.GROUP_MEMBERSHIP_MT.value());
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getGroupMembershipAddEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/groups").path(new VarSpec[]{UriTemplateBuilder.var((String)"groupId")}).literal("/memberships").build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating add endpoint template", e);
        }
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getGroupMembershipByIdEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/groups").path(new VarSpec[]{UriTemplateBuilder.var((String)"groupId")}).literal("/memberships").path(new VarSpec[]{UriTemplateBuilder.var((String)"membershipId")}).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating retrieval endpoint template", e);
        }
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getGroupMembershipDeleteEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/groups").path(new VarSpec[]{UriTemplateBuilder.var((String)"groupId")}).literal("/memberships").path(new VarSpec[]{UriTemplateBuilder.var((String)"membershipId")}).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating modification endpoint template", e);
        }
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getGroupMembershipSearchEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/memberships").build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating search endpoint template", e);
        }
    }

    @Nonnull
    @NotEmpty
    protected final UriTemplate getMembershipsForGroupEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal("/groups").path(new VarSpec[]{UriTemplateBuilder.var((String)"groupId")}).literal("/memberships").build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating search endpoint template", e);
        }
    }

    @Nonnull
    public final GroupMembershipClientImpl build() {
        GroupMembershipClientImpl impl = (GroupMembershipClientImpl)this.populateBaseBuilder(new GroupMembershipClientImpl());
        impl.setAddGroupMembershipUriTemplate(this.getGroupMembershipAddEndpoint());
        impl.setGetGroupMembershipUriTemplate(this.getGroupMembershipByIdEndpoint());
        impl.setDeleteGroupMembershipUriTemplate(this.getGroupMembershipDeleteEndpoint());
        impl.setSearchGroupMembershipUriTemplate(this.getGroupMembershipSearchEndpoint());
        impl.setGetMembershipsForGroupUriTemplate(this.getMembershipsForGroupEndpoint());
        return impl;
    }
}

