/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.client.group.membership;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CachingFutureCallback;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.group.client.group.membership.GroupMembershipClient;
import com.covisint.platform.group.core.group.GroupMembership;
import com.covisint.platform.group.core.group.io.SupportedMediaType;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMembershipClientImpl
extends BaseResourceClient<GroupMembership>
implements GroupMembershipClient {
    private static final MediaType GROUP_MEMBERSHIP_MT = MediaType.parse((String)SupportedMediaType.GROUP_MEMBERSHIP_MT.value());
    private final Logger log = LoggerFactory.getLogger(GroupMembershipClientImpl.class);
    private UriTemplate addGroupMembershipUriTemplate;
    private UriTemplate getGroupMembershipUriTemplate;
    private UriTemplate deleteGroupMembershipUriTemplate;
    private UriTemplate searchGroupMembershipUriTemplate;
    private UriTemplate getMembershipsForGroupUriTemplate;

    @Nonnull
    private MediaType getMediatype(boolean isIncludeGroup, boolean isIncludeGroupAndEntitlements) {
        if (isIncludeGroupAndEntitlements) {
            return MediaType.parse((String)(SupportedMediaType.GROUP_MEMBERSHIP_MT.value() + ";" + SupportedMediaType.PARAM_INCLUDE_GROUP_AND_ENTITLEMENTS.value() + "=" + SupportedMediaType.PARAM_VALUE_TRUE.value()));
        }
        if (isIncludeGroup) {
            return MediaType.parse((String)(SupportedMediaType.GROUP_MEMBERSHIP_MT.value() + ";" + SupportedMediaType.PARAM_INCLUDE_GROUP.value() + "=" + SupportedMediaType.PARAM_VALUE_TRUE.value()));
        }
        return GROUP_MEMBERSHIP_MT;
    }

    @Nonnull
    private CheckedFuture<List<GroupMembership>, ServiceException> doSearch(@Nonnull Multimap<String, String> searchCriteria, @Nonnull SortCriteria sortCriteria, @Nonnull Page page, @Nonnull MediaType mediaType, @Nonnull HttpContext httpContext) {
        String cacheKey = GroupMembershipClientImpl.buildSearchKey(searchCriteria, (SortCriteria)sortCriteria, (Page)page);
        List cachedResult = (List)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            CheckedFuture futureResult = super.search(searchCriteria, sortCriteria, page, httpContext, mediaType, this.searchGroupMembershipUriTemplate.expand());
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    void setAddGroupMembershipUriTemplate(@Nonnull UriTemplate template) {
        this.addGroupMembershipUriTemplate = template;
    }

    void setGetGroupMembershipUriTemplate(@Nonnull UriTemplate template) {
        this.getGroupMembershipUriTemplate = template;
    }

    void setDeleteGroupMembershipUriTemplate(@Nonnull UriTemplate template) {
        this.deleteGroupMembershipUriTemplate = template;
    }

    void setSearchGroupMembershipUriTemplate(UriTemplate template) {
        this.searchGroupMembershipUriTemplate = template;
    }

    void setGetMembershipsForGroupUriTemplate(UriTemplate template) {
        this.getMembershipsForGroupUriTemplate = template;
    }

    @Override
    @Nonnull
    public CheckedFuture<GroupMembership, ServiceException> add(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty GroupMembership groupMembership, @Nonnull HttpContext httpContext) {
        try {
            String url = this.addGroupMembershipUriTemplate.set("groupId", (Object)groupId).expand();
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPost(url), GROUP_MEMBERSHIP_MT, groupMembership, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<GroupMembership, ServiceException> get(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty String membershipId, @Nonnull HttpContext httpContext) {
        String cacheKey = String.format("get-by-id-groupId:%s-membershipId:%s", groupId, membershipId);
        GroupMembership cachedResult = (GroupMembership)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.getGroupMembershipUriTemplate.set("groupId", (Object)groupId).set("membershipId", (Object)membershipId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), GROUP_MEMBERSHIP_MT, httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<Void, ServiceException> delete(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty String membershipId, @Nonnull HttpContext httpContext) {
        try {
            String url = this.deleteGroupMembershipUriTemplate.set("groupId", (Object)groupId).set("membershipId", (Object)membershipId).expand();
            return this.execute((HttpUriRequest)new HttpDelete(url), GROUP_MEMBERSHIP_MT, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<GroupMembership, ServiceException> get(String groupId, String membershipId, boolean isIncludeGroup, boolean isIncludeGroupAndEntitlements, HttpContext httpContext) {
        try {
            String url = this.getGroupMembershipUriTemplate.set("groupId", (Object)groupId).set("membershipId", (Object)membershipId).expand();
            return this.execute((HttpUriRequest)new HttpGet(url), this.getMediatype(isIncludeGroup, isIncludeGroupAndEntitlements), httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<List<GroupMembership>, ServiceException> search(@Nonnull Multimap<String, String> searchCriteria, @Nonnull SortCriteria sortCriteria, @Nonnull Page page, @Nonnull HttpContext httpContext) {
        return this.doSearch(searchCriteria, sortCriteria, page, GROUP_MEMBERSHIP_MT, httpContext);
    }

    @Override
    @Nonnull
    public CheckedFuture<List<GroupMembership>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, @Nonnull Page page, boolean isIncludeGroup, boolean isIncludeGroupAndEntitlements, HttpContext httpContext) {
        return this.doSearch(searchCriteria, sortCriteria, page, this.getMediatype(isIncludeGroup, isIncludeGroupAndEntitlements), httpContext);
    }

    public CheckedFuture<GroupMembership, ServiceException> add(GroupMembership resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<GroupMembership, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<GroupMembership, ServiceException> get(GroupMembership resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<GroupMembership, ServiceException> get(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<GroupMembership, ServiceException> persist(GroupMembership resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<GroupMembership>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CheckedFuture<List<GroupMembership>, ServiceException> listGroupMemberships(@Nonnull @NotEmpty String groupId, boolean isIncludeGroup, boolean isIncludeGroupAndEntitlements, @Nonnull HttpContext httpContext) {
        try {
            String url = this.getMembershipsForGroupUriTemplate.set("groupId", (Object)groupId).expand();
            return this.execute((HttpUriRequest)new HttpGet(url), this.getMediatype(isIncludeGroup, isIncludeGroupAndEntitlements), httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }
}

