/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.group.client.group.entitlement.GroupEntitlementClientFactory;
import com.covisint.platform.group.client.group.entitlement.GroupEntitlementClientImpl;
import com.covisint.platform.group.core.group.GroupEntitlement;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class GroupEntitlementSDK
extends GroupEntitlementClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public GroupEntitlementSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public GroupEntitlementSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public GroupEntitlementClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public GroupEntitlementClient newClient() {
        return new ClientImpl((GroupEntitlementClientImpl)super.create());
    }

    private static final class ClientImpl
    implements GroupEntitlementClient {
        private final GroupEntitlementClientImpl delegate;

        private ClientImpl(@Nonnull GroupEntitlementClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<GroupEntitlement, ServiceException> add(@Nonnull @NotEmpty String groupId, @Nonnull GroupEntitlement entitlement) {
            return this.delegate.add(groupId, entitlement, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<GroupEntitlement, ServiceException> get(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty String entitlementId) {
            return this.delegate.get(groupId, entitlementId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<GroupEntitlement>, ServiceException> listEntitlements(@Nonnull @NotEmpty String groupId, @Nonnull Page page) {
            return this.delegate.search((Multimap<String, String>)ArrayListMultimap.create(), SortCriteria.NONE, page, groupId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<GroupEntitlement>, ServiceException> search(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty @NonnullElements List<String> entitlementIds, Page page) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            searchCriteria.putAll((Object)"id", entitlementIds);
            return this.delegate.search((Multimap<String, String>)searchCriteria, SortCriteria.NONE, page, groupId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> delete(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty String entitlementId) {
            return this.delegate.delete(groupId, entitlementId, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface GroupEntitlementClient {
        @Nonnull
        public CheckedFuture<GroupEntitlement, ServiceException> add(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty GroupEntitlement var2);

        @Nonnull
        public CheckedFuture<GroupEntitlement, ServiceException> get(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);

        @Nonnull
        public CheckedFuture<List<GroupEntitlement>, ServiceException> listEntitlements(@Nonnull @NotEmpty String var1, @Nonnull Page var2);

        @Nonnull
        public CheckedFuture<List<GroupEntitlement>, ServiceException> search(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty @NonnullElements List<String> var2, @Nonnull Page var3);

        @Nonnull
        public CheckedFuture<Void, ServiceException> delete(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);
    }
}

