/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.group.client.group.GroupClientFactory;
import com.covisint.platform.group.client.group.GroupClientImpl;
import com.covisint.platform.group.core.group.Group;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class GroupSDK
extends GroupClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public GroupSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public GroupSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public GroupClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public GroupClient newClient() {
        return new ClientImpl((GroupClientImpl)super.create());
    }

    private static final class ClientImpl
    implements GroupClient {
        private final GroupClientImpl delegate;

        private ClientImpl(@Nonnull GroupClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<Group, ServiceException> get(@Nonnull @NotEmpty String id, boolean includeEntitlements) {
            return this.delegate.get(id, includeEntitlements, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Group, ServiceException> add(@Nonnull Group group) {
            return this.delegate.add((Resource)group, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Group, ServiceException> update(@Nonnull Group group) {
            return this.delegate.persist((Resource)group, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<Group>, ServiceException> search(@NonnullElements List<String> names, @NonnullElements List<String> descriptions, boolean isIncludeEntitlements, @Nonnull Page page, GroupClient.Sort ... sortOrder) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            if (names != null) {
                searchCriteria.putAll((Object)"name", names);
            }
            if (descriptions != null) {
                searchCriteria.putAll((Object)"description", descriptions);
            }
            SortCriteria.Builder sortBuilder = SortCriteria.builder();
            if (sortOrder != null) {
                for (GroupClient.Sort item : sortOrder) {
                    if (item == null) continue;
                    sortBuilder.parseSortField(item.toString());
                }
            }
            return this.delegate.search((Multimap<String, String>)searchCriteria, sortBuilder.build(), page, isIncludeEntitlements, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface GroupClient {
        @Nonnull
        public CheckedFuture<Group, ServiceException> add(@Nonnull Group var1);

        @Nonnull
        public CheckedFuture<Group, ServiceException> update(@Nonnull Group var1);

        @Nonnull
        public CheckedFuture<Group, ServiceException> get(@Nonnull @NotEmpty String var1, boolean var2);

        @Nonnull
        public CheckedFuture<List<Group>, ServiceException> search(@NonnullElements List<String> var1, @NonnullElements List<String> var2, boolean var3, @Nonnull Page var4, Sort ... var5);

        public static enum Sort {
            CREATION_ASC("+creation"),
            CREATION_DESC("-creation");

            private final String id;

            private Sort(String newId) {
                this.id = newId;
            }

            public String toString() {
                return this.id;
            }
        }
    }
}

