/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.support.hibernate;

import com.covisint.core.http.service.core.Resource;
import com.covisint.core.support.aspect.NonnullValidator;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.hibernate.Audited;
import com.covisint.core.support.hibernate.SqlSupport;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuditInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 2936783925404221489L;
    private static final Logger LOG;
    private static final String DEFAULT_AUDIT_TABLE_SUFFIX = "_AUDIT";
    private static EntityManager entityManager;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        AuditInterceptor.ajc$preClinit();
        LOG = LoggerFactory.getLogger(AuditInterceptor.class);
    }

    private static Audited getAuditable(Class<?> cls) {
        if (cls == null) {
            LOG.debug("Given class was not marked @Audited.");
            return null;
        }
        if (cls.getAnnotation(Audited.class) != null) {
            return cls.getAnnotation(Audited.class);
        }
        return AuditInterceptor.getAuditable(cls.getSuperclass());
    }

    private static boolean isAuditable(Class<?> cls) {
        return AuditInterceptor.getAuditable(cls) != null;
    }

    private static String getAuditTableName(Object entity, String mainTableName) {
        String customName = AuditInterceptor.getAuditable(entity.getClass()).auditTableName();
        if (customName == null || customName.isEmpty()) {
            return String.valueOf(mainTableName) + DEFAULT_AUDIT_TABLE_SUFFIX;
        }
        return customName;
    }

    private Session locateHibernateSession() {
        Session session = null;
        try {
            session = (Session)entityManager.unwrap(Session.class);
        }
        catch (PersistenceException e) {
            LOG.error("Unexpected error occurred getting Hibernate session from entity manager", (Throwable)e);
        }
        if (session == null) {
            throw new RuntimeException("Could not get Hibernate session from entity manager.");
        }
        return session;
    }

    private static AbstractEntityPersister getEntityPersister(Class<?> persistentClass, Session session) {
        ClassMetadata md = session.getSessionFactory().getClassMetadata(persistentClass);
        if (!(md instanceof AbstractEntityPersister)) {
            throw new IllegalStateException("Expected class metadata for " + persistentClass.getName() + " to be AbstractEntityPersister, but was " + md.getClass().getName());
        }
        return (AbstractEntityPersister)md;
    }

    private static StringBuilder startInsertStatement(String mainTableName, String auditTableName) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("INSERT INTO ");
        sqlBuilder.append(auditTableName);
        sqlBuilder.append(" SELECT * FROM ");
        sqlBuilder.append(mainTableName);
        return sqlBuilder;
    }

    private static String completeInsertStatement(String[] pkColumnNames, StringBuilder sql) {
        sql.append(" WHERE ");
        int i = 0;
        while (i < pkColumnNames.length) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(pkColumnNames[i].toUpperCase()).append(" = ?");
            ++i;
        }
        LOG.info("Audit insertion SQL: {}", (Object)sql);
        return sql.toString();
    }

    private void audit(final Object entity) {
        if (entityManager == null) {
            throw new IllegalStateException("Entity manager is null.");
        }
        String schemaGenStrategy = (String)entityManager.getEntityManagerFactory().getProperties().get("hibernate.hbm2ddl.auto");
        if (!"validate".equals(schemaGenStrategy)) {
            LOG.warn("Unsupported hibernate.hbm2ddl.auto option: {}.  Cannot proceed with audit of entity type {}", (Object)schemaGenStrategy, (Object)entity.getClass().getName());
            return;
        }
        Session session = this.locateHibernateSession();
        AbstractEntityPersister persister = AuditInterceptor.getEntityPersister(entity.getClass(), session);
        final EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
        String mainTableName = persister.getTableName();
        String auditTableName = AuditInterceptor.getAuditTableName(entity, mainTableName);
        StringBuilder sqlBuilder = AuditInterceptor.startInsertStatement(mainTableName, auditTableName);
        final String sql = AuditInterceptor.completeInsertStatement(persister.getIdentifierColumnNames(), sqlBuilder);
        final int idPropertySpan = persister.getIdentifierColumnNames().length;
        session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                Throwable throwable = null;
                Object var3_4 = null;
                try (PreparedStatement ps = connection.prepareStatement(sql);){
                    int i = 0;
                    while (i < idPropertySpan) {
                        AuditInterceptor.setParamValue(entity, entityMetamodel, ps, i);
                        ++i;
                    }
                    int updateCt = ps.executeUpdate();
                    if (updateCt != 1) {
                        throw new RuntimeException("Unexpected update count (expected 1): " + updateCt);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
    }

    static void setParamValue(Object entity, EntityMetamodel entityMetamodel, PreparedStatement ps, int propertyIndex) throws SQLException {
        Object value = AuditInterceptor.extractIdValue(entity, entityMetamodel, propertyIndex);
        int paramIndex = propertyIndex + 1;
        Class<?> fType = value.getClass();
        if (SqlSupport.isByte(fType)) {
            SqlSupport.setByte(value, ps, paramIndex);
        } else if (SqlSupport.isDouble(fType)) {
            SqlSupport.setDouble(value, ps, paramIndex);
        } else if (SqlSupport.isFloat(fType)) {
            SqlSupport.setFloat(value, ps, paramIndex);
        } else if (SqlSupport.isInt(fType)) {
            SqlSupport.setInteger(value, ps, paramIndex);
        } else if (SqlSupport.isLong(fType)) {
            SqlSupport.setLong(value, ps, paramIndex);
        } else if (SqlSupport.isShort(fType)) {
            SqlSupport.setShort(value, ps, paramIndex);
        } else if (SqlSupport.isBoolean(fType)) {
            SqlSupport.setBoolean(value, ps, paramIndex);
        } else if (SqlSupport.isString(fType) || SqlSupport.isEnum(fType)) {
            SqlSupport.setString(value, ps, paramIndex);
        } else if (value instanceof Resource) {
            SqlSupport.setString(((Resource)value).getId(), ps, paramIndex);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + fType.getName());
        }
    }

    private static Object extractIdValue(Object entity, EntityMetamodel entityMetamodel, int propertyIndex) {
        EntityTuplizer tuplizer = entityMetamodel.getTuplizer();
        IdentifierProperty idProperty = entityMetamodel.getIdentifierProperty();
        if (tuplizer.getIdentifierGetter() != null) {
            return tuplizer.getIdentifierGetter().get(entity);
        }
        if (idProperty.getType() instanceof EmbeddedComponentType) {
            EmbeddedComponentType idType = (EmbeddedComponentType)idProperty.getType();
            return idType.getComponentTuplizer().getPropertyValue(entity, propertyIndex);
        }
        throw new RuntimeException("Unsupported identifier type: " + idProperty.getType());
    }

    @PersistenceContext
    public void setEntityManager(@Nonnull EntityManager em) {
        EntityManager entityManager = em;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)entityManager);
        NonnullValidator.aspectOf().validateMethodArg1((Object)entityManager, joinPoint);
        AuditInterceptor.entityManager = em;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (AuditInterceptor.isAuditable(entity.getClass())) {
            this.audit(entity);
        }
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (AuditInterceptor.isAuditable(entity.getClass())) {
            this.audit(entity);
        }
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AuditInterceptor.java", AuditInterceptor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntityManager", "com.covisint.core.support.hibernate.AuditInterceptor", "javax.persistence.EntityManager", "em", "", "void"), 317);
    }
}

