/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.support.hibernate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.Enumerated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SqlSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SqlSupport.class);

    private SqlSupport() {
    }

    private static void log(Object value, int paramIndex) {
        Class<?> type = null;
        if (value != null) {
            type = value.getClass();
        }
        LOG.debug("Set value {} (type {}) at index {}.", new Object[]{value, type, paramIndex});
    }

    static boolean isByte(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Byte.TYPE.isAssignableFrom(cls) || Byte.class.isAssignableFrom(cls);
    }

    static boolean isDouble(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Double.TYPE.isAssignableFrom(cls) || Double.class.isAssignableFrom(cls);
    }

    static boolean isFloat(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Float.TYPE.isAssignableFrom(cls) || Float.class.isAssignableFrom(cls);
    }

    static boolean isInt(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Integer.TYPE.isAssignableFrom(cls) || Integer.class.isAssignableFrom(cls);
    }

    static boolean isLong(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Long.TYPE.isAssignableFrom(cls) || Long.class.isAssignableFrom(cls);
    }

    static boolean isShort(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Short.TYPE.isAssignableFrom(cls) || Short.class.isAssignableFrom(cls);
    }

    static boolean isString(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return String.class.isAssignableFrom(cls);
    }

    static boolean isBoolean(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Boolean.TYPE.isAssignableFrom(cls) || Boolean.class.isAssignableFrom(cls);
    }

    static boolean isEnum(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return Enum.class.isAssignableFrom(cls);
    }

    static void setByte(Object value, PreparedStatement ps, int paramIndex) throws SQLException {
        if (value == null) {
            ps.setNull(paramIndex, -6);
        } else {
            ps.setByte(paramIndex, (Byte)value);
        }
        SqlSupport.log(value, paramIndex);
    }

    static void setShort(Object value, PreparedStatement ps, int paramIndex) throws SQLException {
        if (value == null) {
            ps.setNull(paramIndex, 5);
        } else {
            ps.setShort(paramIndex, (Short)value);
        }
        SqlSupport.log(value, paramIndex);
    }

    static void setDouble(Object value, PreparedStatement ps, int paramIndex) throws SQLException {
        if (value == null) {
            ps.setNull(paramIndex, 8);
        } else {
            ps.setDouble(paramIndex, (Double)value);
        }
        SqlSupport.log(value, paramIndex);
    }

    static void setFloat(Object value, PreparedStatement ps, int paramIndex) throws SQLException {
        if (value == null) {
            ps.setNull(paramIndex, 7);
        } else {
            ps.setFloat(paramIndex, ((Float)value).floatValue());
        }
        SqlSupport.log(value, paramIndex);
    }

    static void setInteger(Object value, PreparedStatement ps, int paramIndex) throws SQLException {
        if (value == null) {
            ps.setNull(paramIndex, 4);
        } else {
            ps.setInt(paramIndex, (Integer)value);
        }
        SqlSupport.log(value, paramIndex);
    }

    static void setLong(Object value, PreparedStatement ps, int paramIndex) throws SQLException {
        if (value == null) {
            ps.setNull(paramIndex, -5);
        } else {
            ps.setLong(paramIndex, (Long)value);
        }
        SqlSupport.log(value, paramIndex);
    }

    static void setBoolean(Object value, PreparedStatement ps, int paramIndex) throws SQLException {
        if (value == null) {
            ps.setNull(paramIndex, 16);
        } else {
            ps.setBoolean(paramIndex, (Boolean)value);
        }
        SqlSupport.log(value, paramIndex);
    }

    static void setString(Object value, PreparedStatement ps, int paramIndex) throws SQLException {
        if (value == null) {
            ps.setNull(paramIndex, 12);
        } else {
            ps.setString(paramIndex, (String)value);
        }
        SqlSupport.log(value, paramIndex);
    }

    static void setEnum(Enumerated enumerated, Enum<?> value, PreparedStatement ps, int paramIdx) throws SQLException {
        block11: {
            block10: {
                if (enumerated == null) break block10;
                switch (enumerated.value()) {
                    case STRING: {
                        if (value == null) {
                            ps.setNull(paramIdx, 12);
                        } else {
                            ps.setString(paramIdx, value.toString());
                        }
                        break block11;
                    }
                    case ORDINAL: {
                        if (value == null) {
                            ps.setNull(paramIdx, 12);
                        } else {
                            ps.setString(paramIdx, value.toString());
                        }
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported javax.persistence.EnumType");
                    }
                }
            }
            if (value == null) {
                ps.setNull(paramIdx, 4);
            } else {
                ps.setInt(paramIdx, value.ordinal());
            }
        }
        SqlSupport.log(value, paramIdx);
    }
}

