/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.core.group.io.json;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceWriter;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.group.core.group.Group;
import com.covisint.platform.group.core.group.GroupEntitlement;
import com.covisint.platform.group.core.group.GroupJsonSupport;
import com.covisint.platform.group.core.group.io.SupportedMediaType;
import com.covisint.platform.group.core.group.io.json.GroupEntitlementWriter;
import com.google.common.net.MediaType;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class GroupWriter
extends AbstractRealmScopedResourceWriter<Group> {
    private void writeMultiLingualStringMap(@Nonnull @NotEmpty String propertyName, @Nullable Map<String, String> map, @Nonnull @NotEmpty String keyName, @Nonnull @NotEmpty String valueName, @Nonnull JsonObjectBuilder builder) {
        if (map != null && !map.isEmpty()) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (StringSupport.trimOrNull((String)entry.getKey()) == null || StringSupport.trimOrNull((String)entry.getValue()) == null) {
                    arrayBuilder = Json.createArrayBuilder();
                    break;
                }
                arrayBuilder.add(Json.createObjectBuilder().add(keyName, entry.getKey()).add(valueName, entry.getValue()));
            }
            builder.add(propertyName, arrayBuilder);
        }
    }

    private void writeEntitlements(@Nullable Set<GroupEntitlement> entitlements, @Nonnull JsonObjectBuilder builder, @Nonnull MediaType mediaType) {
        if (entitlements != null && !entitlements.isEmpty() && GroupJsonSupport.isExpectedMediaTypeParameterNameAndValue(mediaType, SupportedMediaType.PARAM_INCLUDE_ENTITLEMENTS.value(), SupportedMediaType.PARAM_VALUE_TRUE.value())) {
            JsonArrayBuilder entitlementsBuilder = Json.createArrayBuilder();
            GroupEntitlementWriter entitlementWriter = new GroupEntitlementWriter();
            MediaType entitlementMediaType = MediaType.parse((String)SupportedMediaType.GROUP_ENTITLEMENT_MT.value());
            for (GroupEntitlement entitlement : entitlements) {
                entitlementsBuilder.add(entitlementWriter.writeResource(entitlementMediaType, entitlement));
            }
            builder.add("entitlements", entitlementsBuilder);
        }
    }

    @Nonnull
    public final JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull Group resource) {
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractRealmScopedResource)resource);
        this.writeMultiLingualStringMap("description", resource.getDescription(), "lang", "value", builder);
        this.writeMultiLingualStringMap("name", resource.getName(), "lang", "value", builder);
        this.writeResourceReference("owner", resource.getOwner(), builder);
        this.writeEntitlements(resource.getEntitlements(), builder, mediaType);
        return builder;
    }

    @Nonnull
    public final Class<Group> getResourceType() {
        return Group.class;
    }

    public final boolean isWritable(@Nullable Class clazz, @Nonnull MediaType mediaType) {
        return GroupJsonSupport.isMediaTypeSame(SupportedMediaType.GROUP_MT, mediaType);
    }
}

