/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.platform.oauth.client.subject.SubjectClientFactory;
import com.covisint.platform.oauth.client.subject.SubjectClientImpl;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.oauth.core.domain.Subject;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class SubjectSDK
extends SubjectClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public SubjectSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public SubjectSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public SubjectClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public SubjectClient newClient() {
        return new ClientImpl((SubjectClientImpl)super.create());
    }

    private static final class ClientImpl
    implements SubjectClient {
        private final SubjectClientImpl delegate;

        private ClientImpl(@Nonnull SubjectClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<Subject, ServiceException> delete(@Nonnull @NotEmpty String subjectId) {
            return this.delegate.delete(subjectId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Subject, ServiceException> update(@Nonnull Subject subject) {
            return this.delegate.persist((Resource)subject, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Subject, ServiceException> get(@Nonnull @NotEmpty String subjectId) {
            return this.delegate.get(subjectId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<Subject>, ServiceException> search(List<String> subjectIds, @Nonnull Page page) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            searchCriteria.putAll((Object)"id", Iterables.filter(subjectIds, (Predicate)Predicates.notNull()));
            return this.delegate.search((Multimap)searchCriteria, SortCriteria.NONE, page, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface SubjectClient {
        @Nonnull
        public CheckedFuture<Subject, ServiceException> delete(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<Subject, ServiceException> update(@Nonnull Subject var1);

        @Nonnull
        public CheckedFuture<Subject, ServiceException> get(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<List<Subject>, ServiceException> search(@Nonnull @NonnullElements List<String> var1, @Nonnull Page var2);
    }
}

