/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.token.io.json;

import com.covisint.core.http.service.core.AbstractResource;
import com.covisint.core.http.service.core.io.jsonp.AbstractResourceWriter;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.oauth.core.JsonpSupport;
import com.covisint.platform.oauth.core.SupportedMediaType;
import com.covisint.platform.oauth.core.token.LegacyToken;
import com.google.common.net.MediaType;
import javax.json.JsonObjectBuilder;

public class TokenWriter
extends AbstractResourceWriter<LegacyToken> {
    @Nonnull
    protected JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull LegacyToken resource) {
        JsonObjectBuilder jsonBuilder = super.writeResource(mediaType, (AbstractResource)resource);
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"access_token", (String)resource.getEncodedToken());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"expires_in", (String)Long.toString(resource.getLifeTime()));
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"token_type", (String)resource.getType());
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"expirationTime", (String)Long.toString(resource.getExpirationTime()));
        com.covisint.core.http.service.core.io.jsonp.JsonpSupport.addPropertyIfNonnullValue((JsonObjectBuilder)jsonBuilder, (String)"issueTime", (String)Long.toString(resource.getIssueTime()));
        return jsonBuilder;
    }

    public boolean isWritable(@Nullable Class clazz, @Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.TOKEN_MT, mediaType) || JsonpSupport.isMediaTypeSame(SupportedMediaType.JSON_MT, mediaType);
    }

    @Nonnull
    public Class getResourceType() {
        return LegacyToken.class;
    }
}

