/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.client;

import com.covisint.core.support.constraint.Constraints;
import com.google.common.base.Objects;
import com.google.common.cache.Weigher;

public final class CacheSpec {
    private long maxElements;
    private long maxWeight;
    private Weigher weigher;
    private long expiration;
    private ExpirationMode expirationMode = ExpirationMode.AFTER_ACCESS;

    public static Builder builder() {
        return new Builder();
    }

    public long getMaxElements() {
        return this.maxElements;
    }

    public long getMaxWeight() {
        return this.maxWeight;
    }

    public Weigher getWeigher() {
        return this.weigher;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public ExpirationMode getExpirationMode() {
        return this.expirationMode;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.maxElements, this.maxWeight, this.weigher, this.expiration, this.expirationMode});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CacheSpec)) {
            return false;
        }
        CacheSpec other = (CacheSpec)obj;
        return this.maxElements == other.maxElements && this.maxWeight == other.maxWeight && Objects.equal((Object)this.weigher, (Object)other.weigher) && this.expiration == other.expiration && this.expirationMode == other.expirationMode;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("maxElements", this.maxElements).add("maxWeight", this.maxWeight).add("weigher", (Object)this.weigher).add("expiration", this.expiration).add("expirationMode", (Object)this.expirationMode).toString();
    }

    public static enum ExpirationMode {
        AFTER_ACCESS,
        AFTER_WRITE;

    }

    public static class Builder {
        private final CacheSpec config = new CacheSpec();

        public Builder maxElements(long max) {
            Constraints.isGreaterThanOrEqual((long)0L, (long)max, (String)"Max elements cannot be negative.");
            this.config.maxElements = max;
            return this;
        }

        public Builder maxWeight(long max, Weigher weigher) {
            Constraints.isGreaterThanOrEqual((long)0L, (long)max, (String)"Max weight cannot be negative.");
            this.config.maxWeight = max;
            this.config.weigher = weigher;
            return this;
        }

        public Builder expiration(long expirationMillis, ExpirationMode expirationMode) {
            this.config.expiration = expirationMillis;
            this.config.expirationMode = expirationMode;
            return this;
        }

        public CacheSpec build() {
            return this.config;
        }
    }
}

