/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.client;

import com.covisint.core.http.service.client.BaseResourceClientFactory;
import com.covisint.core.support.constraint.Nonnull;
import com.google.common.base.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientInitializationContext {
    private static Logger log = LoggerFactory.getLogger(ClientInitializationContext.class);
    private static final ThreadLocal<ClientInitializationContext> THREADLOCAL = new InheritableThreadLocal(){

        @Override
        protected ClientInitializationContext initialValue() {
            return new ClientInitializationContext();
        }
    };
    private BaseResourceClientFactory clientFactory;

    private ClientInitializationContext() {
    }

    static void setClientFactory(@Nonnull BaseResourceClientFactory factory) {
        ClientInitializationContext.get().clientFactory = factory;
    }

    static void set(@Nonnull ClientInitializationContext context) {
        THREADLOCAL.set(context);
        log.debug("Set invocation context on thread local: {}", (Object)context);
    }

    public static BaseResourceClientFactory getClientFactory() {
        return ClientInitializationContext.get().clientFactory;
    }

    public static void clear() {
        ClientInitializationContext context = ClientInitializationContext.get();
        if (context != null) {
            log.debug("Clear initialization context on thread local: {}", (Object)context);
            THREADLOCAL.remove();
        }
    }

    public static ClientInitializationContext get() {
        return THREADLOCAL.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientInitializationContext)) {
            return false;
        }
        ClientInitializationContext that = (ClientInitializationContext)obj;
        return Objects.equal((Object)this.clientFactory, (Object)that.clientFactory);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientFactory});
    }

    @Nonnull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("clientFactory", (Object)this.clientFactory).toString();
    }
}

