/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core.io.jsonp;

import com.covisint.core.http.service.core.HttpServiceError;
import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceErrorWriter<T extends HttpServiceError>
implements EntityWriter {
    public static final String PRETTY_PRINT_MT_ATTRIB = "pretty";
    private final Logger log = LoggerFactory.getLogger(HttpServiceErrorWriter.class);

    @Nonnull
    public Class<HttpServiceError> getResourceType() {
        return HttpServiceError.class;
    }

    public boolean isWritable(Class clazz, MediaType mediaType) {
        return HttpServiceError.class.isAssignableFrom(clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final MediaType write(@Nonnull MediaType mediaType, @Nonnull Object source, @Nonnull OutputStream output) {
        JsonObject json;
        this.log.debug("Preparing to write an object of type {}, into a JSON structure", (Object)source.getClass().getName());
        if (!Collection.class.isInstance(source)) {
            json = this.writeResource(JsonpSupport.HTTP_SERVICE_ERROR_V1_MEDIA_TYPE, (HttpServiceError)source).build();
        } else {
            this.log.debug("Create JSON array for collection of resources");
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (Object resource : (Collection)source) {
                if (resource == null) {
                    this.log.debug("Encountered null element in collection, skipping it");
                    continue;
                }
                jsonArrayBuilder.add(this.writeResource(JsonpSupport.HTTP_SERVICE_ERROR_V1_MEDIA_TYPE, (HttpServiceError)resource));
            }
            json = jsonArrayBuilder.build();
        }
        this.log.debug("A JSON structure of type {} was created for an object of type {}", (Object)json.getValueType().toString(), (Object)source.getClass().getName());
        JsonWriterFactory factory = this.createWriterFactory(JsonpSupport.HTTP_SERVICE_ERROR_V1_MEDIA_TYPE);
        try (JsonWriter writer = factory.createWriter(output, Charsets.UTF_8);){
            this.log.debug("Writing JSON to output stream");
            writer.write((JsonStructure)json);
            MediaType mediaType2 = JsonpSupport.HTTP_SERVICE_ERROR_V1_MEDIA_TYPE;
            return mediaType2;
        }
        catch (IllegalStateException | JsonException e) {
            this.log.debug("Unable to write JSON to output stream", e);
            throw new EntityWriterException("Unable to write JSON");
        }
    }

    protected JsonObjectBuilder writeResource(MediaType mediaType, T resource) {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        jsonBuilder.add("status", ((HttpServiceError)resource).getHttpStatusCode());
        JsonpSupport.addPropertyIfNonnullValue(jsonBuilder, "apiMessage", ((HttpServiceError)resource).getApiMessage());
        JsonpSupport.addPropertyIfNonnullValue(jsonBuilder, "apiStatusCode", ((HttpServiceError)resource).getApiStatusCode());
        return jsonBuilder;
    }

    @Nonnull
    private JsonWriterFactory createWriterFactory(@Nonnull MediaType mediaType) {
        this.log.debug("Creating JSON writer factory");
        HashMap<String, Boolean> writerConfig = new HashMap<String, Boolean>();
        boolean prettyPrint = this.isPrettyPrintEnabled(mediaType);
        this.log.debug("Pretty printing enabled? {}", (Object)prettyPrint);
        writerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", prettyPrint);
        return Json.createWriterFactory(writerConfig);
    }

    private boolean isPrettyPrintEnabled(@Nonnull MediaType mediaType) {
        ImmutableList prettyPrintParams = mediaType.parameters().get((Object)PRETTY_PRINT_MT_ATTRIB);
        if (prettyPrintParams == null || prettyPrintParams.isEmpty()) {
            return false;
        }
        return Boolean.valueOf((String)prettyPrintParams.get(0));
    }
}

