/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.domain;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.NullableElements;
import com.covisint.platform.oauth.core.domain.AbstractGrantType;
import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="Subject")
public class Subject
extends AbstractRealmScopedResource<Subject> {
    private static final long serialVersionUID = -202597796414991491L;
    @OneToMany(mappedBy="subjectResource", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Set<AbstractGrantType> grantType = new HashSet<AbstractGrantType>();

    @Nullable
    public String getCuid() {
        return this.getId();
    }

    public void setCuid(String cuid) {
        this.setId(cuid);
    }

    @Nonnull
    @NullableElements
    public Set<? extends AbstractGrantType> getGrantType() {
        return this.grantType;
    }

    public void addGrantType(AbstractGrantType resource) {
        this.grantType.add(resource);
    }

    public void setGrantType(Set<? extends AbstractGrantType> type) {
        this.grantType.clear();
        for (AbstractGrantType abstractGrantType : type) {
            this.grantType.add(abstractGrantType);
        }
    }

    @Nonnull
    @NotEmpty
    public final String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).toString();
    }

    public final int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public final boolean equals(Object obj) {
        return this.isResourceIdentityEqual(Subject.class, obj);
    }
}

