/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.token;

import com.covisint.core.http.service.client.BaseResourceClientBuilder;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.oauth.client.token.TokenClientImpl;
import com.covisint.platform.oauth.core.SupportedMediaType;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.google.common.net.MediaType;

public class TokenClientBuilder
extends BaseResourceClientBuilder<TokenClientBuilder, TokenClientImpl> {
    private static final String RESOURCE_COLLECTION_PATH = "/token";

    @Nonnull
    @NotEmpty
    protected String getResourceCollectionPath() {
        return RESOURCE_COLLECTION_PATH;
    }

    @Nonnull
    protected MediaType getResourceRepresentation() {
        return MediaType.parse((String)SupportedMediaType.TOKEN_MT.value());
    }

    @Nonnull
    protected final UriTemplate getTokenEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getResourceCollectionPath()).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating retrieval endpoint template", e);
        }
    }

    @Nonnull
    protected final UriTemplate postTokenEndpoint() {
        try {
            return UriTemplate.buildFromTemplate((String)this.getServiceBaseUrl()).literal(this.getResourceCollectionPath()).build();
        }
        catch (MalformedUriTemplateException e) {
            throw new IllegalStateException("Error creating retrieval endpoint template", e);
        }
    }

    @Nonnull
    public TokenClientImpl build() {
        TokenClientImpl impl = (TokenClientImpl)this.populateBaseBuilder(new TokenClientImpl());
        impl.setGetTokenUriTemplate(this.getTokenEndpoint());
        impl.setPostTokenUriTemplate(this.postTokenEndpoint());
        return impl;
    }
}

