/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.core.group;

import com.covisint.core.http.service.core.AbstractRealmScopedResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.NullableElements;
import com.covisint.core.support.constraint.Searchable;
import com.covisint.core.support.hibernate.Audited;
import com.covisint.platform.group.core.group.GroupEntitlement;
import com.covisint.platform.group.core.group.GroupMembership;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Audited
@Entity
@Table(name="GROUPS")
public class Group
extends AbstractRealmScopedResource<Group> {
    private static final long serialVersionUID = 3463100829632377259L;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="GROUP_NAMES")
    @MapKeyColumn(name="LANGUAGE", length=10, nullable=false)
    @Column(name="TEXT", length=2000, nullable=false)
    @Searchable
    @NonnullElements
    private Map<String, String> name = Collections.emptyMap();
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="GROUP_DESCRIPTIONS")
    @MapKeyColumn(name="LANGUAGE", length=10, nullable=false)
    @Column(name="TEXT", length=2000, nullable=false)
    @Searchable
    @NonnullElements
    private Map<String, String> description = Collections.emptyMap();
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="OWNER_ID", length=64, nullable=false)), @AttributeOverride(name="type", column=@Column(name="OWNER_TYPE", length=128)), @AttributeOverride(name="realm", column=@Column(name="OWNER_REALM", length=25))})
    @Nonnull
    private ResourceReference owner;
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="group", fetch=FetchType.EAGER)
    private Set<GroupMembership> memberships = new HashSet<GroupMembership>();
    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="group", fetch=FetchType.EAGER)
    private Set<GroupEntitlement> entitlements = new HashSet<GroupEntitlement>();

    @Nullable
    public final Map<String, String> getName() {
        return Collections.unmodifiableMap(this.name);
    }

    @Nonnull
    public final Group setName(@Nonnull @NotEmpty Map<String, String> newName) {
        this.name = new HashMap<String, String>(newName);
        return this;
    }

    @Nonnull
    @NullableElements
    public final Map<String, String> getDescription() {
        return Collections.unmodifiableMap(this.description);
    }

    @Nonnull
    public final Group setDescription(@Nonnull @NotEmpty Map<String, String> newDescription) {
        this.description = new HashMap<String, String>(newDescription);
        return this;
    }

    @Nonnull
    @NullableElements
    public final Set<GroupMembership> getMemberships() {
        return Collections.unmodifiableSet(this.memberships);
    }

    @Nonnull
    public final Group setMemberships(@Nonnull @NonnullElements Set<GroupMembership> newMemberships) {
        this.memberships = new HashSet<GroupMembership>(newMemberships);
        return this;
    }

    @Nonnull
    @NullableElements
    public final Set<GroupEntitlement> getEntitlements() {
        return Collections.unmodifiableSet(this.entitlements);
    }

    @Nonnull
    public Group setEntitlements(@Nonnull @NonnullElements Set<GroupEntitlement> newEntitlements) {
        this.entitlements = new HashSet<GroupEntitlement>(newEntitlements);
        return this;
    }

    @Nullable
    public final ResourceReference getOwner() {
        return this.owner;
    }

    @Nonnull
    public final Group setOwner(@Nonnull ResourceReference newOwner) {
        this.owner = newOwner;
        return this;
    }

    @Nonnull
    @NotEmpty
    public final String toString() {
        return this.populateToStringHelper(Objects.toStringHelper((Object)((Object)this))).add("name", this.getName()).add("description", this.getDescription()).add("owner", (Object)this.getOwner()).toString();
    }

    public final int hashCode() {
        return this.getResourceIdentityHashCode();
    }

    public final boolean equals(Object obj) {
        return this.isResourceIdentityEqual(Group.class, obj);
    }
}

