/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.core.group;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class LibInfo {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String MVN_ENTRY = "Maven";
    private static final String MVN_ART_GRP = "ArtifactGroup";
    private static final String MVN_ART_ID = "ArtifactId";
    private static final String MVN_ART_VER = "ArtifactVersion";
    private static final String SCM_ENTRY = "SCM";
    private static final String SCM_REPO = "Repository";
    private static final String SCM_PATH = "Path";
    private static final String SCM_REV = "Revision";
    private static final String SCM_UNC_CHNG = "UncommitedChanges";
    private static final String BLD_ENTRY = "Build";
    private static final String BLD_OS_NAME = "OsName";
    private static final String BLD_OS_VER = "OsVersion";
    private static final String BLD_OS_ARCH = "OsArch";
    private static final String BLD_J_VEND = "JavaVendor";
    private static final String BLD_J_VER = "JavaVersion";
    private static final String BLD_INSTANT = "BuildInstant";
    private static final String BLD_BLDR = "Builder";
    private static Manifest jarManifest;

    private LibInfo() {
    }

    public static void main(String[] args) {
        System.out.println("Maven Information:");
        System.out.println("  Group:     " + LibInfo.getMavenGroupId());
        System.out.println("  Artifact:  " + LibInfo.getMavenArtifactId());
        System.out.println("  Version:   " + LibInfo.getMavenArtifactVersion());
        System.out.println();
        System.out.println("SCM Information:");
        System.out.println("  Repository:  " + LibInfo.getScmRepository());
        System.out.println("  Path:        " + LibInfo.getScmPath());
        System.out.println("  Revision:    " + LibInfo.getScmRevision());
        System.out.println("  Uncommited:  " + LibInfo.getScmHasUncommitedChanges());
        System.out.println();
        System.out.println("Build Information:");
        System.out.println("  OS Name:          " + LibInfo.getBuildOsName());
        System.out.println("  OS Version:       " + LibInfo.getBuildOsVersion());
        System.out.println("  OS Architecture:  " + LibInfo.getBuildOsArchitecture());
        System.out.println("  Java Vendor:      " + LibInfo.getBuildJavaVendor());
        System.out.println("  Java Version:     " + LibInfo.getBuildJavaVersion());
        System.out.println("  Build Instant:    " + LibInfo.getBuildInstant());
        System.out.println("  Builder:          " + LibInfo.getBuilder());
    }

    public static String getMavenGroupId() {
        return jarManifest.getAttributes(MVN_ENTRY).getValue(MVN_ART_GRP);
    }

    public static String getMavenArtifactId() {
        return jarManifest.getAttributes(MVN_ENTRY).getValue(MVN_ART_ID);
    }

    public static String getMavenArtifactVersion() {
        return jarManifest.getAttributes(MVN_ENTRY).getValue(MVN_ART_VER);
    }

    public static String getScmRepository() {
        return jarManifest.getAttributes(SCM_ENTRY).getValue(SCM_REPO);
    }

    public static String getScmPath() {
        return jarManifest.getAttributes(SCM_ENTRY).getValue(SCM_PATH);
    }

    public static String getScmRevision() {
        return jarManifest.getAttributes(SCM_ENTRY).getValue(SCM_REV);
    }

    public static boolean getScmHasUncommitedChanges() {
        return Boolean.valueOf(jarManifest.getAttributes(SCM_ENTRY).getValue(SCM_UNC_CHNG));
    }

    public static String getBuildOsName() {
        return jarManifest.getAttributes(BLD_ENTRY).getValue(BLD_OS_NAME);
    }

    public static String getBuildOsVersion() {
        return jarManifest.getAttributes(BLD_ENTRY).getValue(BLD_OS_VER);
    }

    public static String getBuildOsArchitecture() {
        return jarManifest.getAttributes(BLD_ENTRY).getValue(BLD_OS_ARCH);
    }

    public static String getBuildJavaVendor() {
        return jarManifest.getAttributes(BLD_ENTRY).getValue(BLD_J_VEND);
    }

    public static String getBuildJavaVersion() {
        return jarManifest.getAttributes(BLD_ENTRY).getValue(BLD_J_VER);
    }

    public static String getBuildInstant() {
        return jarManifest.getAttributes(BLD_ENTRY).getValue(BLD_INSTANT);
    }

    public static String getBuilder() {
        return jarManifest.getAttributes(BLD_ENTRY).getValue(BLD_BLDR);
    }

    static {
        try {
            Enumeration<URL> resources = LibInfo.class.getClassLoader().getResources(MANIFEST_PATH);
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes entryAttributes = manifest.getEntries().get(MVN_ENTRY);
                if (entryAttributes == null || !LibInfo.class.getPackage().getName().equals(entryAttributes.getValue(MVN_ART_GRP))) continue;
                jarManifest = manifest;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

