/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.core.group.io.json;

import com.covisint.core.http.service.core.AbstractResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractResourceWriter;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.group.core.group.Group;
import com.covisint.platform.group.core.group.GroupJsonSupport;
import com.covisint.platform.group.core.group.GroupMembership;
import com.covisint.platform.group.core.group.io.SupportedMediaType;
import com.covisint.platform.group.core.group.io.json.GroupWriter;
import com.google.common.net.MediaType;
import javax.json.JsonObjectBuilder;

public class GroupMembershipWriter
extends AbstractResourceWriter<GroupMembership> {
    private MediaType getGroupWithEntitlementsMediaType() {
        return MediaType.parse((String)(SupportedMediaType.GROUP_MT.value() + ";" + SupportedMediaType.PARAM_INCLUDE_ENTITLEMENTS.value() + "=" + SupportedMediaType.PARAM_VALUE_TRUE.value()));
    }

    private void writeGroup(@Nullable Group group, @Nonnull JsonObjectBuilder builder, @Nonnull MediaType mediaType) {
        if (group != null) {
            JsonObjectBuilder groupBuilder = null;
            GroupWriter groupWriter = new GroupWriter();
            if (GroupJsonSupport.isExpectedMediaTypeParameterNameAndValue(mediaType, SupportedMediaType.PARAM_INCLUDE_GROUP_AND_ENTITLEMENTS.value(), SupportedMediaType.PARAM_VALUE_TRUE.value())) {
                groupBuilder = groupWriter.writeResource(this.getGroupWithEntitlementsMediaType(), group);
            } else if (GroupJsonSupport.isExpectedMediaTypeParameterNameAndValue(mediaType, SupportedMediaType.PARAM_INCLUDE_GROUP.value(), SupportedMediaType.PARAM_VALUE_TRUE.value())) {
                groupBuilder = groupWriter.writeResource(MediaType.parse((String)SupportedMediaType.GROUP_MT.value()), group);
            } else {
                ResourceReference groupReference = new ResourceReference(group.getId(), "group", group.getRealm());
                this.writeResourceReference("group", groupReference, builder);
                return;
            }
            builder.add("group", groupBuilder);
        }
    }

    public final boolean isWritable(@Nullable Class clazz, @Nonnull MediaType mediaType) {
        return GroupJsonSupport.isMediaTypeSame(SupportedMediaType.GROUP_MEMBERSHIP_MT, mediaType);
    }

    @Nonnull
    public final JsonObjectBuilder writeResource(@Nonnull MediaType mediaType, @Nonnull GroupMembership resource) {
        JsonObjectBuilder builder = super.writeResource(mediaType, (AbstractResource)resource);
        this.writeGroup(resource.getGroup(), builder, mediaType);
        this.writeResourceReference("member", resource.getMember(), builder);
        return builder;
    }

    @Nonnull
    public final Class<GroupMembership> getResourceType() {
        return GroupMembership.class;
    }
}

