/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.core.group.io.json;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.group.core.group.Group;
import com.covisint.platform.group.core.group.GroupEntitlement;
import com.covisint.platform.group.core.group.GroupJsonSupport;
import com.covisint.platform.group.core.group.io.SupportedMediaType;
import com.covisint.platform.group.core.group.io.json.GroupEntitlementReader;
import com.google.common.net.MediaType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;

public class GroupReader
extends AbstractRealmScopedResourceReader<Group> {
    @Nullable
    private Map<String, String> unmarshallMultiLingualStringMap(@Nonnull JsonArray mapJsonArray) {
        Map<String, String> map = Collections.emptyMap();
        if (mapJsonArray != null) {
            map = new HashMap<String, String>();
            for (JsonObject multiLingualString : mapJsonArray) {
                JsonString languageJsonKey = multiLingualString.getJsonString("lang");
                JsonString languageJsonValue = multiLingualString.getJsonString("value");
                if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)languageJsonKey) && !JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)languageJsonValue)) {
                    map.put(languageJsonKey.getString(), languageJsonValue.getString());
                    continue;
                }
                map.clear();
                break;
            }
        }
        return map;
    }

    @Nonnull
    protected Group createResource(@Nonnull MediaType mediaType) {
        return new Group();
    }

    @Nonnull
    public final Class<Group> getResourceType() {
        return Group.class;
    }

    public final boolean isReadable(@Nonnull MediaType mediaType) {
        return GroupJsonSupport.isMediaTypeSame(SupportedMediaType.GROUP_MT, mediaType);
    }

    @Nonnull
    public final Group readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        Group resource = (Group)super.readResource(mediaType, json);
        JsonArray descriptionJson = json.getJsonArray("description");
        resource.setDescription(this.unmarshallMultiLingualStringMap(descriptionJson));
        JsonArray nameJson = json.getJsonArray("name");
        resource.setName(this.unmarshallMultiLingualStringMap(nameJson));
        ResourceReference owner = GroupReader.readResourceReference((JsonObject)json.getJsonObject("owner"));
        if (owner != null) {
            resource.setOwner(owner);
        }
        GroupEntitlementReader entitlementReader = new GroupEntitlementReader();
        MediaType entitlementMediaType = MediaType.parse((String)SupportedMediaType.GROUP_ENTITLEMENT_MT.value());
        JsonArray jsonArray = json.getJsonArray("entitlements");
        HashSet<GroupEntitlement> entitlements = new HashSet<GroupEntitlement>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                GroupEntitlement entitlement = entitlementReader.readResource(entitlementMediaType, jsonArray.getJsonObject(i));
                entitlements.add(entitlement);
            }
        }
        resource.setEntitlements(entitlements);
        return resource;
    }
}

