/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.client.group;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CachingFutureCallback;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.group.client.group.GroupClient;
import com.covisint.platform.group.core.group.Group;
import com.covisint.platform.group.core.group.io.SupportedMediaType;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupClientImpl
extends BaseResourceClient<Group>
implements GroupClient {
    private static final MediaType GROUP_MT = MediaType.parse((String)SupportedMediaType.GROUP_MT.value());
    private final Logger log = LoggerFactory.getLogger(GroupClientImpl.class);
    private UriTemplate getByIdWithEntitlementsEndpointUriTemplate;
    private UriTemplate searchGroupsWithEntitlementsEndpointUriTemplate;

    @Nonnull
    private MediaType getMediatype(boolean isIncludeEntitlements) {
        if (isIncludeEntitlements) {
            return MediaType.parse((String)(SupportedMediaType.GROUP_MT.value() + ";" + SupportedMediaType.PARAM_INCLUDE_ENTITLEMENTS.value() + "=" + SupportedMediaType.PARAM_VALUE_TRUE.value()));
        }
        return GROUP_MT;
    }

    void setGetByIdWithEntitlementsEndpointUriTemplate(@Nonnull UriTemplate template) {
        this.getByIdWithEntitlementsEndpointUriTemplate = template;
    }

    void setSearchGroupsWithEntitlementsEndpointUriTemplate(UriTemplate template) {
        this.searchGroupsWithEntitlementsEndpointUriTemplate = template;
    }

    @Override
    @Nonnull
    public CheckedFuture<Group, ServiceException> get(@Nonnull @NotEmpty String groupId, boolean isIncludeEntitlements, @Nonnull HttpContext httpContext) {
        String cacheKey = String.format("get-by-id-%s-includeEntitlements:%s", groupId, isIncludeEntitlements);
        Group cachedResult = (Group)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.getByIdWithEntitlementsEndpointUriTemplate.set("groupId", (Object)groupId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), this.getMediatype(isIncludeEntitlements), httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<List<Group>, ServiceException> search(@Nonnull Multimap<String, String> searchCriteria, @Nonnull SortCriteria sortCriteria, @Nonnull Page page, boolean isIncludeEntitlements, @Nonnull HttpContext httpContext) {
        ArrayListMultimap keyCriteria = ArrayListMultimap.create(searchCriteria);
        keyCriteria.put((Object)"includeEntitlements", (Object)String.valueOf(isIncludeEntitlements));
        String cacheKey = GroupClientImpl.buildSearchKey((Multimap)keyCriteria, (SortCriteria)sortCriteria, (Page)page);
        List cachedResult = (List)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            CheckedFuture futureResult = super.search(searchCriteria, sortCriteria, page, httpContext, this.getMediatype(isIncludeEntitlements), this.searchGroupsWithEntitlementsEndpointUriTemplate.expand());
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<Group, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

