/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.client.group.entitlement;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CachingFutureCallback;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.group.client.group.entitlement.GroupEntitlementClient;
import com.covisint.platform.group.core.group.GroupEntitlement;
import com.covisint.platform.group.core.group.io.SupportedMediaType;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupEntitlementClientImpl
extends BaseResourceClient<GroupEntitlement>
implements GroupEntitlementClient {
    static final MediaType GROUP_ENTITLEMENT_MT = MediaType.parse((String)SupportedMediaType.GROUP_ENTITLEMENT_MT.value());
    private final Logger log = LoggerFactory.getLogger(GroupEntitlementClientImpl.class);
    private UriTemplate addUriTemplate;
    private UriTemplate getByIdUriTemplate;
    private UriTemplate searchUriTemplate;
    private UriTemplate deleteUriTemplate;

    void setAddUriTemplate(@Nonnull UriTemplate template) {
        this.addUriTemplate = template;
    }

    void setGetByIdUriTemplate(@Nonnull UriTemplate template) {
        this.getByIdUriTemplate = template;
    }

    void setSearchUriTemplate(@Nonnull UriTemplate template) {
        this.searchUriTemplate = template;
    }

    void setDeleteUriTemplate(@Nonnull UriTemplate template) {
        this.deleteUriTemplate = template;
    }

    @Override
    @Nonnull
    public CheckedFuture<GroupEntitlement, ServiceException> add(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty GroupEntitlement groupEntitlement, @Nonnull HttpContext httpContext) {
        try {
            String url = this.addUriTemplate.set("groupId", (Object)groupId).expand();
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPost(url), GROUP_ENTITLEMENT_MT, groupEntitlement, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<GroupEntitlement, ServiceException> get(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty String entitlementId, @Nonnull HttpContext httpContext) {
        String cacheKey = String.format("get-by-id-groupId:%s-entitlementId:%s", groupId, entitlementId);
        GroupEntitlement cachedResult = (GroupEntitlement)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.getByIdUriTemplate.set("groupId", (Object)groupId).set("entitlementId", (Object)entitlementId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), GROUP_ENTITLEMENT_MT, httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<List<GroupEntitlement>, ServiceException> search(@Nonnull Multimap<String, String> searchCriteria, @Nonnull SortCriteria sortCriteria, @Nonnull Page page, @Nonnull @NotEmpty String groupId, @Nonnull HttpContext httpContext) {
        String cacheKey = GroupEntitlementClientImpl.buildSearchKey(searchCriteria, (SortCriteria)sortCriteria, (Page)page);
        List cachedResult = (List)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.searchUriTemplate.set("groupId", (Object)groupId).expand();
            CheckedFuture futureResult = super.search(searchCriteria, sortCriteria, page, httpContext, GROUP_ENTITLEMENT_MT, url);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<Void, ServiceException> delete(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty String entitlementId, @Nonnull HttpContext httpContext) {
        try {
            String url = this.deleteUriTemplate.set("groupId", (Object)groupId).set("entitlementId", (Object)entitlementId).expand();
            return this.execute((HttpUriRequest)new HttpDelete(url), GROUP_ENTITLEMENT_MT, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<GroupEntitlement, ServiceException> add(GroupEntitlement resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<GroupEntitlement, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<GroupEntitlement, ServiceException> get(GroupEntitlement resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<GroupEntitlement, ServiceException> get(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<GroupEntitlement, ServiceException> persist(GroupEntitlement resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<GroupEntitlement>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<GroupEntitlement>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        throw new UnsupportedOperationException();
    }
}

