/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.group.client.sdk;

import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.group.client.group.membership.GroupMembershipClientFactory;
import com.covisint.platform.group.client.group.membership.GroupMembershipClientImpl;
import com.covisint.platform.group.core.group.GroupMembership;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class GroupMembershipSDK
extends GroupMembershipClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public GroupMembershipSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public GroupMembershipSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public GroupMembershipClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public GroupMembershipClient newClient() {
        return new ClientImpl((GroupMembershipClientImpl)super.create());
    }

    private static final class ClientImpl
    implements GroupMembershipClient {
        private final GroupMembershipClientImpl delegate;

        private ClientImpl(@Nonnull GroupMembershipClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<GroupMembership, ServiceException> add(@Nonnull @NotEmpty String groupId, @Nonnull GroupMembership membership) {
            return this.delegate.add(groupId, membership, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Void, ServiceException> delete(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty String membershipId) {
            return this.delegate.delete(groupId, membershipId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<GroupMembership, ServiceException> get(@Nonnull @NotEmpty String groupId, @Nonnull @NotEmpty String membershipId, @Nonnull GroupMembershipClient.ResponseOption option) {
            return this.delegate.get(groupId, membershipId, option == GroupMembershipClient.ResponseOption.INCLUDE_GROUP, option == GroupMembershipClient.ResponseOption.INCLUDE_GROUP_WITH_ENTITLEMENTS, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<GroupMembership>, ServiceException> search(String memberId, String memberType, String groupOwnerId, String groupOwnerType, @Nonnull Page page, @Nonnull GroupMembershipClient.ResponseOption option) {
            ArrayListMultimap searchCriteria = ArrayListMultimap.create();
            searchCriteria.put((Object)"member.id", (Object)memberId);
            if (StringSupport.trimOrNull((String)memberType) != null) {
                searchCriteria.put((Object)"member.type", (Object)memberType);
            }
            if (StringSupport.trimOrNull((String)groupOwnerId) != null) {
                searchCriteria.put((Object)"group.owner.id", (Object)groupOwnerId);
            }
            if (StringSupport.trimOrNull((String)groupOwnerType) != null) {
                searchCriteria.put((Object)"group.owner.type", (Object)groupOwnerType);
            }
            return this.delegate.search((Multimap<String, String>)searchCriteria, SortCriteria.NONE, page, option == GroupMembershipClient.ResponseOption.INCLUDE_GROUP, option == GroupMembershipClient.ResponseOption.INCLUDE_GROUP_WITH_ENTITLEMENTS, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<GroupMembership>, ServiceException> listGroupMemberships(@Nonnull @NotEmpty String groupId, @Nonnull GroupMembershipClient.ResponseOption option) {
            return this.delegate.listGroupMemberships(groupId, option == GroupMembershipClient.ResponseOption.INCLUDE_GROUP, option == GroupMembershipClient.ResponseOption.INCLUDE_GROUP_WITH_ENTITLEMENTS, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface GroupMembershipClient {
        @Nonnull
        public CheckedFuture<GroupMembership, ServiceException> add(@Nonnull @NotEmpty String var1, @Nonnull GroupMembership var2);

        @Nonnull
        public CheckedFuture<Void, ServiceException> delete(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2);

        @Nonnull
        public CheckedFuture<GroupMembership, ServiceException> get(@Nonnull @NotEmpty String var1, @Nonnull @NotEmpty String var2, @Nonnull ResponseOption var3);

        @Nonnull
        public CheckedFuture<List<GroupMembership>, ServiceException> search(@Nonnull @NotEmpty String var1, String var2, String var3, String var4, @Nonnull Page var5, @Nonnull ResponseOption var6);

        @Nonnull
        public CheckedFuture<List<GroupMembership>, ServiceException> listGroupMemberships(@Nonnull @NotEmpty String var1, @Nonnull ResponseOption var2);

        public static enum ResponseOption {
            NONE,
            INCLUDE_GROUP,
            INCLUDE_GROUP_WITH_ENTITLEMENTS;

        }
    }
}

