/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.granttype.clientsecret;

import com.covisint.core.http.service.client.BaseResourceClient;
import com.covisint.core.http.service.client.CachingFutureCallback;
import com.covisint.core.http.service.client.ClientException;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.platform.oauth.client.granttype.clientsecret.ClientSecretGrantTypeClient;
import com.covisint.platform.oauth.core.SupportedMediaType;
import com.covisint.platform.oauth.core.domain.ClientSecretGrantType;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSecretGrantTypeClientImpl
extends BaseResourceClient<ClientSecretGrantType>
implements ClientSecretGrantTypeClient {
    private static final MediaType CLIENT_SECRET_GRANT_V1_MEDIA_TYPE = MediaType.parse((String)SupportedMediaType.CLIENT_SECRET_GRANT_MT.value());
    private final Logger log = LoggerFactory.getLogger(ClientSecretGrantTypeClientImpl.class);
    private UriTemplate getClientSecretGrantTypeUriTemplate;
    private UriTemplate searchClientSecretGrantTypeUriTemplate;
    private UriTemplate postClientSecretGrantTypeUriTemplate;
    private UriTemplate deleteClientSecretGrantTypeUriTemplate;

    @Nonnull
    private HttpGet getHttpGet(@Nonnull @NotEmpty String url, @Nonnull HttpContext httpContext) {
        HttpGet get = new HttpGet(url);
        get.setHeader("type", "client_credentials");
        return get;
    }

    void setGetClientSecretGrantTypeUriTemplate(@Nonnull UriTemplate template) {
        this.getClientSecretGrantTypeUriTemplate = template;
    }

    void setSearchClientSecretGrantTypeUriTemplate(@Nonnull UriTemplate template) {
        this.searchClientSecretGrantTypeUriTemplate = template;
    }

    void setPostClientSecretGrantTypeUriTemplate(@Nonnull UriTemplate template) {
        this.postClientSecretGrantTypeUriTemplate = template;
    }

    void setDeleteClientSecretGrantTypeUriTemplate(@Nonnull UriTemplate template) {
        this.deleteClientSecretGrantTypeUriTemplate = template;
    }

    @Override
    @Nonnull
    public CheckedFuture<ClientSecretGrantType, ServiceException> get(@Nonnull @NotEmpty String subjectId, @Nonnull @NotEmpty String grantTypeId, @Nonnull HttpContext httpContext) {
        String cacheKey = String.format("get-by-id-subjectId:%s-grantTypeId:%s", subjectId, grantTypeId);
        ClientSecretGrantType cachedResult = (ClientSecretGrantType)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.getClientSecretGrantTypeUriTemplate.set("subjectId", (Object)subjectId).set("grantTypeId", (Object)grantTypeId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)new HttpGet(url), CLIENT_SECRET_GRANT_V1_MEDIA_TYPE, httpContext);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<List<ClientSecretGrantType>, ServiceException> search(@Nonnull @NotEmpty String subjectId, @Nonnull Multimap<String, String> searchCriteria, @Nonnull SortCriteria sortCriteria, @Nonnull Page page, @Nonnull HttpContext context) {
        String cacheKey = ClientSecretGrantTypeClientImpl.buildSearchKey(searchCriteria, (SortCriteria)sortCriteria, (Page)page);
        List cachedResult = (List)this.getLocalCache().getIfPresent((Object)cacheKey);
        if (cachedResult != null) {
            this.log.debug("Found active cache for key {}; using it.", (Object)cacheKey);
            return Futures.immediateCheckedFuture((Object)cachedResult);
        }
        try {
            String url = this.searchClientSecretGrantTypeUriTemplate.set("subjectId", (Object)subjectId).expand();
            CheckedFuture futureResult = this.execute((HttpUriRequest)this.getHttpGet(this.getEndpointWithQueryParams(searchCriteria, sortCriteria, page, url), context), CLIENT_SECRET_GRANT_V1_MEDIA_TYPE, context);
            Futures.addCallback((ListenableFuture)futureResult, (FutureCallback)new CachingFutureCallback(this.getLocalCache(), cacheKey));
            return futureResult;
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<ClientSecretGrantType, ServiceException> add(@Nonnull @NotEmpty String subjectId, @Nonnull ClientSecretGrantType clientSecretGrantType, @Nonnull HttpContext httpContext) {
        try {
            String url = this.postClientSecretGrantTypeUriTemplate.set("subjectId", (Object)subjectId).expand();
            return this.executeWithBody((HttpEntityEnclosingRequestBase)new HttpPost(url), CLIENT_SECRET_GRANT_V1_MEDIA_TYPE, clientSecretGrantType, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    @Override
    @Nonnull
    public CheckedFuture<ClientSecretGrantType, ServiceException> delete(@Nonnull @NotEmpty String subjectId, @Nonnull @NotEmpty String grantTypeId, @Nonnull HttpContext httpContext) {
        try {
            String url = this.deleteClientSecretGrantTypeUriTemplate.set("subjectId", (Object)subjectId).set("grantTypeId", (Object)grantTypeId).expand();
            return this.execute((HttpUriRequest)new HttpDelete(url), CLIENT_SECRET_GRANT_V1_MEDIA_TYPE, httpContext);
        }
        catch (VariableExpansionException e) {
            this.log.error("Error occurred while expanding URL template.", (Throwable)e);
            throw new ClientException("Error occurred while expanding URL template.");
        }
    }

    public CheckedFuture<ClientSecretGrantType, ServiceException> add(ClientSecretGrantType resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<ClientSecretGrantType, ServiceException> delete(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<ClientSecretGrantType, ServiceException> get(ClientSecretGrantType resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<ClientSecretGrantType, ServiceException> get(String id, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<ClientSecretGrantType, ServiceException> persist(ClientSecretGrantType resource, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<ClientSecretGrantType>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public CheckedFuture<List<ClientSecretGrantType>, ServiceException> search(Multimap<String, String> searchCriteria, SortCriteria sortCriteria, Page page, HttpContext httpContext, MediaType mediaType, String searchResourcesEndPoint) {
        throw new UnsupportedOperationException();
    }
}

