/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.client.token.sdk;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.oauth.client.token.sdk.AbstractClasspathPropertyLoader;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public final class DefaultAuthConfigurationProvider
extends AbstractClasspathPropertyLoader
implements AuthConfigurationProvider {
    private static final String DEFAULT_FILE_NAME = "client.conf";
    private String applicationId;
    private String clientId;
    private String clientSecret;
    private URL authServiceBaseUrl;

    public DefaultAuthConfigurationProvider() {
        this.loadCredentials();
    }

    private void loadCredentials() {
        Properties props = this.getProperties();
        this.applicationId = this.getRequiredProperty(props, "applicationId");
        this.clientId = this.getRequiredProperty(props, "clientId");
        this.clientSecret = this.getRequiredProperty(props, "clientSecret");
        try {
            this.authServiceBaseUrl = new URL(this.getRequiredProperty(props, "authServiceBaseUrl"));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Bad auth service URL", e);
        }
    }

    private String getRequiredProperty(Properties props, String propertyName) {
        return (String)Constraints.isNotNull((Object)StringSupport.trimOrNull((String)props.getProperty(propertyName)), (String)(propertyName + " property not set."));
    }

    @Override
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @Nonnull
    public URL getAuthServiceBaseUrl() {
        return this.authServiceBaseUrl;
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getPropertyFileName() {
        return DEFAULT_FILE_NAME;
    }
}

