/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core.io.jsonp;

import com.covisint.core.http.service.core.NamedResourceReference;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.ResourceReferenceNode;
import com.covisint.core.http.service.core.io.EntityWriter;
import com.covisint.core.http.service.core.io.EntityWriterException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.common.net.MediaType;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityHierarchyWriter
implements EntityWriter<ResourceReferenceNode> {
    private final Logger log = LoggerFactory.getLogger(EntityHierarchyWriter.class);

    @Nonnull
    private JsonObjectBuilder writeNode(@Nonnull ResourceReferenceNode source) {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        JsonpSupport.addPropertyIfNonnullValue(jsonBuilder, "id", ((ResourceReference)source.getValue()).getId());
        JsonpSupport.addPropertyIfNonnullValue(jsonBuilder, "type", ((ResourceReference)source.getValue()).getType());
        JsonpSupport.addPropertyIfNonnullValue(jsonBuilder, "realm", ((ResourceReference)source.getValue()).getRealm());
        this.writeInternationalValues(jsonBuilder, ((NamedResourceReference)source.getValue()).getName(), "name");
        this.writeInternationalValues(jsonBuilder, ((NamedResourceReference)source.getValue()).getDescription(), "description");
        this.writeChildren(source, jsonBuilder);
        return jsonBuilder;
    }

    private void writeChildren(ResourceReferenceNode<NamedResourceReference> source, JsonObjectBuilder jsonBuilder) {
        if (source.getChildren() == null || Iterables.isEmpty(source.getChildren())) {
            return;
        }
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (ResourceReferenceNode o : source.getChildren()) {
            JsonObjectBuilder childBuilder = this.writeNode(o);
            if (childBuilder == null) continue;
            builder.add(childBuilder);
        }
        jsonBuilder.add("children", builder);
    }

    private void writeInternationalValues(JsonObjectBuilder jsonBuilder, Map<String, String> source, String propertyName) {
        if (source == null || source.isEmpty()) {
            return;
        }
        JsonArrayBuilder mapBuilder = Json.createArrayBuilder();
        for (Map.Entry<String, String> e : source.entrySet()) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            JsonpSupport.addPropertyIfNonnullValue(builder, "lang", e.getKey());
            JsonpSupport.addPropertyIfNonnullValue(builder, "text", source.get(e.getKey()));
            mapBuilder.add(builder);
        }
        jsonBuilder.add(propertyName, mapBuilder);
    }

    @Override
    @Nonnull
    public Class<ResourceReferenceNode> getResourceType() {
        return ResourceReferenceNode.class;
    }

    @Override
    public boolean isWritable(@Nonnull Class<?> clazz, @Nonnull MediaType mediaType) {
        return JsonpSupport.RESOURCE_HIERARCHY_V1_MEDIA_TYPE.equals((Object)mediaType.withoutParameters());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MediaType write(@Nonnull MediaType mediaType, @Nonnull ResourceReferenceNode source, @Nonnull OutputStream output) {
        this.log.debug("Preparing to write an object of type {}, into a JSON structure", (Object)source.getClass().getName());
        JsonObject json = this.writeNode(source).build();
        JsonWriterFactory factory = Json.createWriterFactory((Map)Collections.EMPTY_MAP);
        try (JsonWriter writer = factory.createWriter(output, Charsets.UTF_8);){
            writer.write((JsonStructure)json);
            MediaType mediaType2 = mediaType;
            return mediaType2;
        }
        catch (IllegalStateException | JsonException e) {
            throw new EntityWriterException("Unable to write JSON");
        }
    }
}

