/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.granttype.certificate;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.oauth.core.GrantTypeQualifier;
import com.covisint.platform.oauth.core.authentication.Authenticator;
import com.covisint.platform.oauth.core.domain.AbstractGrantType;
import com.covisint.platform.oauth.core.domain.CertificateGrantType;
import com.covisint.platform.oauth.core.granttype.GrantTypeBuilder;
import com.covisint.platform.oauth.core.util.CertificateUtils;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GrantTypeQualifier(value="certificate")
public class CertificateGrantTypeBuilder
implements GrantTypeBuilder {
    private final Logger log = LoggerFactory.getLogger(CertificateGrantTypeBuilder.class);
    private Authenticator authenticator;
    private CertificateFactory factory;

    public CertificateGrantTypeBuilder() {
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            this.log.error("Unable to create a X.509 certificate factory");
        }
    }

    private void populateClientId(@Nonnull CertificateGrantType certType, @Nonnull Map<String, Object> userInfo) {
        if (userInfo.get("clientId") != null) {
            certType.setId((String)userInfo.get("clientId"));
        }
        if (certType.getId() == null) {
            certType.setId((String)userInfo.get("clientId".toLowerCase()));
        }
        if (certType.getId() == null) {
            certType.setId((String)userInfo.get("x-client-id".toLowerCase()));
        }
    }

    private void populatePublicKey(@Nonnull CertificateGrantType certType, @Nonnull Map<String, Object> userInfo) throws GeneralSecurityException {
        String pubkey;
        String cert;
        if (userInfo.get("publicKey") != null) {
            certType.setPubKey((String)userInfo.get("publicKey"));
        }
        if ((cert = (String)userInfo.get("X-Client-Cert")) == null) {
            cert = (String)userInfo.get("X-Client-Cert".toLowerCase());
        }
        if (cert == null) {
            cert = (String)userInfo.get("cert");
        }
        if ((pubkey = (String)userInfo.get("publicKey")) == null) {
            pubkey = (String)userInfo.get("publicKey".toLowerCase());
        }
        if (cert != null) {
            Certificate certificate = this.parseCertificate(cert);
            certType.setPubKey(CertificateUtils.serializePublicKey(certificate.getPublicKey()));
        } else if (pubkey != null) {
            PublicKey key = this.parsePublicKey(pubkey);
            certType.setPubKey(CertificateUtils.serializePublicKey(key));
        }
    }

    private PublicKey parsePublicKey(String pubkey) throws GeneralSecurityException {
        byte[] encKey = Base64.decodeBase64((byte[])pubkey.getBytes());
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(pubKeySpec);
    }

    private Certificate parseCertificate(String cert) throws CertificateException {
        ByteArrayInputStream stream = new ByteArrayInputStream(cert.getBytes());
        Certificate certificate = this.factory.generateCertificate(stream);
        return certificate;
    }

    @Override
    public boolean isApplicable(@Nonnull Class<? extends AbstractGrantType> user) {
        return CertificateGrantType.class.isAssignableFrom(user);
    }

    @Override
    @Nonnull
    public Class<? extends AbstractGrantType> getSupportedClassType() {
        return CertificateGrantType.class;
    }

    @Override
    @Nullable
    public AbstractGrantType build(@Nonnull Map<String, Object> userInfo) {
        CertificateGrantType certType = new CertificateGrantType();
        try {
            if (userInfo.get("type") != null) {
                certType.setType((String)userInfo.get("type"));
            }
            this.populateClientId(certType, userInfo);
            this.populatePublicKey(certType, userInfo);
            if (certType.getPubKey() != null) {
                return certType;
            }
            Object object = userInfo.get("javax.servlet.request.X509Certificate");
            if (object instanceof Certificate) {
                certType.setPubKey(CertificateUtils.serializePublicKey(((Certificate)object).getPublicKey()));
            }
            if (certType.getPubKey() == null) {
                this.log.error("No certificate or public key found for certificate grant type");
                return null;
            }
            return certType;
        }
        catch (GeneralSecurityException e) {
            this.log.error("Error occurred while trying to retrieve certificate", (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator auth) {
        this.authenticator = auth;
    }
}

