/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.token.io.json;

import com.covisint.core.http.service.core.io.jsonp.AbstractResourceReader;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.oauth.core.JsonpSupport;
import com.covisint.platform.oauth.core.SupportedMediaType;
import com.covisint.platform.oauth.core.token.LegacyToken;
import com.google.common.net.MediaType;
import javax.json.JsonObject;
import javax.json.JsonString;

public class TokenReader
extends AbstractResourceReader<LegacyToken> {
    @Nonnull
    protected LegacyToken readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        LegacyToken token = (LegacyToken)super.readResource(mediaType, json);
        JsonString stringValue = json.getJsonString("access_token");
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringValue)) {
            token.setAccessToken(stringValue.getString());
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = json.getJsonString("expires_in")))) {
            token.setExpiresIn(Long.valueOf(stringValue.getString()));
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = json.getJsonString("expirationTime")))) {
            token.setExpirationTime(Long.valueOf(stringValue.getString()));
        }
        if (!com.covisint.core.http.service.core.io.jsonp.JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringValue = json.getJsonString("issueTime")))) {
            token.setIssueTime(Long.valueOf(stringValue.getString()));
        }
        return token;
    }

    @Nullable
    protected LegacyToken createResource(@Nonnull MediaType mediaType) {
        return new LegacyToken();
    }

    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.isMediaTypeSame(SupportedMediaType.TOKEN_MT, mediaType) || JsonpSupport.isMediaTypeSame(SupportedMediaType.JSON_MT, mediaType);
    }

    public Class getResourceType() {
        return LegacyToken.class;
    }
}

