/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.constraint.Searchable;
import com.google.common.base.Objects;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public class ResourceReference {
    @Searchable
    @Column(name="ID", length=64)
    private String id;
    @Searchable
    @Column(name="TYPE", length=128)
    private String type;
    @Searchable(name="realmId")
    @Column(name="REALM", length=25)
    private String realm;

    private ResourceReference() {
    }

    public ResourceReference(@Nonnull @NotEmpty String resourceId, @Nullable @NotEmpty String resourceType) {
        this(resourceId, resourceType, null);
    }

    public ResourceReference(@Nonnull @NotEmpty String resourceId, @Nullable @NotEmpty String resourceType, @Nullable String resourceRealm) {
        this.id = resourceId;
        this.type = resourceType;
        this.realm = resourceRealm;
    }

    @Nullable
    @NotEmpty
    public String getId() {
        return this.id;
    }

    @Nullable
    @NotEmpty
    public String getType() {
        return this.type;
    }

    @Nullable
    @NotEmpty
    public String getRealm() {
        return this.realm;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResourceReference)) {
            return false;
        }
        ResourceReference that = (ResourceReference)obj;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.realm, (Object)that.realm);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.type, this.realm});
    }

    @Nonnull
    @NotEmpty
    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.type).add("realm", (Object)this.realm).toString();
    }
}

