/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core.io.jsonp;

import com.covisint.core.http.service.core.NamedResourceReference;
import com.covisint.core.http.service.core.ResourceReferenceNode;
import com.covisint.core.http.service.core.io.EntityParsingException;
import com.covisint.core.http.service.core.io.EntityReader;
import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityHierarchyReader
implements EntityReader<ResourceReferenceNode> {
    private final Logger log = LoggerFactory.getLogger(EntityHierarchyReader.class);

    @Nonnull
    private NamedResourceReference doReadNode(@Nonnull JsonObject json) {
        if (json == null) {
            return null;
        }
        JsonString id = json.getJsonString("id");
        JsonString realm = json.getJsonString("realm");
        JsonString type = json.getJsonString("type");
        Map<String, String> name = this.readStringMap(json.getJsonArray("name"));
        Map<String, String> description = this.readStringMap(json.getJsonArray("description"));
        return new NamedResourceReference(id.getString(), type.getString(), realm.getString(), name, description);
    }

    @Nullable
    private Map<String, String> readStringMap(JsonArray json) {
        if (json == null) {
            return null;
        }
        List jsonList = json.getValuesAs(JsonObject.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (JsonObject object : jsonList) {
            map.put(((JsonValue)object.get((Object)"lang")).toString(), ((JsonValue)object.get((Object)"text")).toString());
        }
        return map;
    }

    @Nonnull
    private ResourceReferenceNode readNode(@Nonnull JsonObject json, @Nullable JsonObject parent) {
        if (json == null) {
            return null;
        }
        NamedResourceReference nodeValue = this.doReadNode(json);
        NamedResourceReference nodeParent = this.doReadNode(parent);
        ResourceReferenceNode<NamedResourceReference> node = new ResourceReferenceNode<NamedResourceReference>(nodeValue, nodeParent);
        if (json.getJsonArray("children") != null) {
            List children = json.getJsonArray("children").getValuesAs(JsonObject.class);
            JsonObject newParent = json;
            for (JsonObject child : children) {
                node.addChild(this.readNode(child, newParent));
            }
        }
        return node;
    }

    @Override
    @Nonnull
    public Class<ResourceReferenceNode> getResourceType() {
        return ResourceReferenceNode.class;
    }

    @Override
    public boolean isReadable(@Nonnull MediaType mediaType) {
        return JsonpSupport.RESOURCE_HIERARCHY_V1_MEDIA_TYPE.equals((Object)mediaType.withoutParameters());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceReferenceNode read(@Nonnull MediaType mediaType, @Nonnull InputStream input) {
        this.log.debug("Preparing to parse JSON data from inputstream");
        try (JsonReader jsonReader = Json.createReader((InputStream)input);){
            JsonStructure json = jsonReader.read();
            if (!JsonpSupport.isObject((JsonValue)json)) {
                throw new EntityReaderException("Root-level JSON structure of " + json.getValueType().toString() + " is not supported.");
            }
            ResourceReferenceNode resourceReferenceNode = this.readNode((JsonObject)json, null);
            return resourceReferenceNode;
        }
        catch (JsonParsingException e) {
            throw new EntityParsingException(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), (Throwable)e);
        }
        catch (ClassCastException | IllegalStateException | JsonException e) {
            throw new EntityReaderException("Unable to parse JSON");
        }
    }
}

