/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.support.aspect;

import java.util.Collection;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public final class NotEmptyValidator {
    private static final String METHOD_ARG_EMPTY_MESSAGE = "Method arg at index %d failed constraint @NotEmpty.";
    private static final String CONSTRUCTOR_ARG_EMPTY_MESSAGE = "Constructor arg at index %d failed constraint @NotEmpty.";
    private static final String METHOD_RETURN_EMPTY_MESSAGE = "Method return type failed constraint @NotEmpty.";
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ NotEmptyValidator ajc$perSingletonInstance;

    private static void assertNotEmpty(String messageTemplate, Integer paramIndex, Object object, JoinPoint joinPoint) {
        if (object == null) {
            return;
        }
        boolean isEmpty = false;
        if (object instanceof Collection) {
            isEmpty = ((Collection)object).isEmpty();
        } else if (object instanceof String) {
            isEmpty = ((String)object).trim().isEmpty();
        }
        if (!isEmpty) {
            return;
        }
        StringBuilder message = paramIndex != null ? new StringBuilder(String.format(messageTemplate, paramIndex)) : new StringBuilder(messageTemplate);
        String ls = System.lineSeparator();
        message.append(ls).append("Method: ").append(joinPoint.getSignature().toLongString()).append(ls);
        if (joinPoint.getSourceLocation() != null) {
            message.append("Line: ").append(joinPoint.getSourceLocation().getLine());
        }
        throw new IllegalArgumentException(message.toString());
    }

    @Before(value="execution(* *(@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(value,..)")
    public void validateMethodArg1(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(METHOD_ARG_EMPTY_MESSAGE, 1, value, joinPoint);
    }

    @Before(value="execution(* *(*,@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(*,value,..)")
    public void validateMethodArg2(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(METHOD_ARG_EMPTY_MESSAGE, 2, value, joinPoint);
    }

    @Before(value="execution(* *(*,*,@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(*,*,value,..)")
    public void validateMethodArg3(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(METHOD_ARG_EMPTY_MESSAGE, 3, value, joinPoint);
    }

    @Before(value="execution(* *(*,*,*,@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(*,*,*,value,..)")
    public void validateMethodArg4(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(METHOD_ARG_EMPTY_MESSAGE, 4, value, joinPoint);
    }

    @Before(value="execution(* *(*,*,*,*,@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(*,*,*,*,value,..)")
    public void validateMethodArg5(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(METHOD_ARG_EMPTY_MESSAGE, 5, value, joinPoint);
    }

    @Before(value="execution(new(@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(value,..)")
    public void validateConstructorArg1(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 1, value, joinPoint);
    }

    @Before(value="execution(new(*,@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(*,value,..)")
    public void validateConstructorArg2(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 2, value, joinPoint);
    }

    @Before(value="execution(new(*,*,@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(*,*,value,..)")
    public void validateConstructorArg3(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 3, value, joinPoint);
    }

    @Before(value="execution(new(*,*,*,@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(*,*,*,value,..)")
    public void validateConstructorArg4(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 4, value, joinPoint);
    }

    @Before(value="execution(new(*,*,*,*,@com.covisint.core.support.constraint.NotEmpty (*),..)) && args(*,*,*,*,value,..)")
    public void validateConstructorArg5(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 5, value, joinPoint);
    }

    @AfterReturning(pointcut="execution(@com.covisint.core.support.constraint.NotEmpty * *(..))", returning="value")
    public void validateMethodReturnValue(Object value, JoinPoint joinPoint) {
        NotEmptyValidator.assertNotEmpty(METHOD_RETURN_EMPTY_MESSAGE, null, value, joinPoint);
    }

    public static NotEmptyValidator aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.covisint.core.support.aspect.NotEmptyValidator", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            NotEmptyValidator.ajc$perSingletonInstance = new NotEmptyValidator();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

