/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.granttype.clientsecret;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.oauth.core.GrantTypeQualifier;
import com.covisint.platform.oauth.core.authentication.Authenticator;
import com.covisint.platform.oauth.core.domain.AbstractGrantType;
import com.covisint.platform.oauth.core.domain.ClientSecretGrantType;
import com.covisint.platform.oauth.core.granttype.GrantTypeBuilder;
import com.covisint.platform.oauth.core.util.BasicAuthenticationParser;
import com.google.common.base.Charsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GrantTypeQualifier(value="client_credentials")
public class ClientSecretGrantTypeBuilder
implements GrantTypeBuilder {
    private final Logger log = LoggerFactory.getLogger(ClientSecretGrantTypeBuilder.class);
    private Authenticator authenticator;

    private void parseBasicAuthentication(Map<String, Object> userInfo) {
        Object secret;
        String[] info;
        String header = (String)userInfo.get("Authorization");
        if (header == null) {
            header = (String)userInfo.get("authorization");
        }
        if (header != null && header.startsWith("Basic ") && (info = BasicAuthenticationParser.parse(header, Charsets.UTF_8)).length == 2) {
            userInfo.put("clientId", info[0]);
            userInfo.put("clientSecret", info[1]);
            return;
        }
        Object client = userInfo.get("x-client-id");
        if (client != null) {
            userInfo.put("clientId", client);
        }
        if ((secret = userInfo.get("x-client-secret")) != null) {
            userInfo.put("clientSecret", secret);
        }
    }

    @Override
    @Nullable
    public AbstractGrantType build(@Nonnull Map<String, Object> userInfo) {
        ClientSecretGrantType user = new ClientSecretGrantType();
        this.parseBasicAuthentication(userInfo);
        this.log.debug("building grant type for client secret");
        if (userInfo.get("clientSecret") != null) {
            user.setClientSecret((String)userInfo.get("clientSecret"));
        }
        if (userInfo.get("type") != null) {
            user.setType((String)userInfo.get("type"));
        }
        if (userInfo.get("clientId") != null) {
            user.setId((String)userInfo.get("clientId"));
        }
        return user;
    }

    @Override
    public boolean isApplicable(@Nonnull Class<? extends AbstractGrantType> user) {
        return ClientSecretGrantType.class.isAssignableFrom(user);
    }

    @Override
    @Nonnull
    public Class<? extends AbstractGrantType> getSupportedClassType() {
        return ClientSecretGrantType.class;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator auth) {
        this.authenticator = auth;
    }
}

