/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.oauth.core.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicAuthenticationParser {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthenticationParser.class);

    private BasicAuthenticationParser() {
    }

    public static String[] parse(String header, Charset chr) {
        byte[] decoded;
        byte[] base64Token;
        try {
            base64Token = header.substring(6).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to retrieve Basic auth information", (Throwable)e);
            return new String[0];
        }
        try {
            decoded = Base64.decodeBase64((byte[])base64Token);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Failed to decode basic authentication token", (Throwable)e);
            return new String[0];
        }
        String token = new String(decoded, chr);
        int delim = token.indexOf(":");
        if (delim < 0) {
            LOG.error("Invalid basic authentication token");
            return new String[0];
        }
        return new String[]{token.substring(0, delim), token.substring(delim + 1)};
    }

    public static String getUsername(String basicAuth, Charset charset) {
        String[] decoded = BasicAuthenticationParser.parse(basicAuth, charset);
        if (decoded == null || decoded.length == 0) {
            return null;
        }
        return decoded[0];
    }
}

