/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import com.damnhandy.uri.template.Expression;
import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.UriTemplateComponent;
import com.damnhandy.uri.template.UriUtil;
import com.damnhandy.uri.template.VarExploder;
import com.damnhandy.uri.template.VariableExpansionException;
import com.damnhandy.uri.template.impl.Modifier;
import com.damnhandy.uri.template.impl.Operator;
import com.damnhandy.uri.template.impl.UriTemplateParser;
import com.damnhandy.uri.template.impl.VarExploderFactory;
import com.damnhandy.uri.template.impl.VarSpec;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class UriTemplate
implements Serializable {
    private static final long serialVersionUID = -5245084430838445979L;
    public static final String DEFAULT_SEPARATOR = ",";
    protected DateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    static final char[] OPERATORS = new char[]{'+', '#', '.', '/', ';', '?', '&', '!', '='};
    private static final BitSet OPERATOR_BITSET = new BitSet();
    private String template;
    private Pattern reverseMatchPattern;
    private Map<String, Object> values = new HashMap<String, Object>();
    private LinkedList<UriTemplateComponent> components;
    private Expression[] expressions;
    private String[] variables;

    private UriTemplate(String template) throws MalformedUriTemplateException {
        this.template = template;
        this.parseTemplateString();
    }

    protected UriTemplate(LinkedList<UriTemplateComponent> components) {
        this.components = components;
        this.initExpressions();
        this.buildTemplateStringFromComponents();
    }

    public static UriTemplateBuilder buildFromTemplate(String template) throws MalformedUriTemplateException {
        return new UriTemplateBuilder(template);
    }

    public static UriTemplateBuilder buildFromTemplate(UriTemplate template) throws MalformedUriTemplateException {
        return new UriTemplateBuilder(template);
    }

    public static final UriTemplate fromTemplate(String templateString) throws MalformedUriTemplateException {
        return new UriTemplate(templateString);
    }

    public static UriTemplateBuilder fromTemplate(UriTemplate base) throws MalformedUriTemplateException {
        return new UriTemplateBuilder(base.getTemplate());
    }

    public int expressionCount() {
        return this.expressions.length;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }

    public String[] getVariables() {
        if (this.variables == null) {
            LinkedHashSet<String> vars = new LinkedHashSet<String>();
            for (Expression e : this.getExpressions()) {
                for (VarSpec v : e.getVarSpecs()) {
                    vars.add(v.getVariableName());
                }
            }
            this.variables = vars.toArray(new String[vars.size()]);
        }
        return this.variables;
    }

    protected void parseTemplateString() throws MalformedUriTemplateException {
        String templateString = this.getTemplate();
        UriTemplateParser scanner = new UriTemplateParser();
        this.components = scanner.scan(templateString);
        this.initExpressions();
    }

    private void initExpressions() {
        LinkedList<Expression> expressionList = new LinkedList<Expression>();
        for (UriTemplateComponent c : this.components) {
            if (!(c instanceof Expression)) continue;
            expressionList.add((Expression)c);
        }
        this.expressions = expressionList.toArray(new Expression[expressionList.size()]);
    }

    private void buildTemplateStringFromComponents() {
        StringBuilder b = new StringBuilder();
        for (UriTemplateComponent c : this.components) {
            b.append(c.getValue());
        }
        this.template = b.toString();
    }

    private void buildReverssMatchRegexFromComponents() {
        StringBuilder b = new StringBuilder();
        for (UriTemplateComponent c : this.components) {
            b.append("(").append(c.getMatchPattern()).append(")");
        }
        this.reverseMatchPattern = Pattern.compile(b.toString());
    }

    protected Pattern getReverseMatchPattern() {
        if (this.reverseMatchPattern == null) {
            this.buildReverssMatchRegexFromComponents();
        }
        return this.reverseMatchPattern;
    }

    public static String expand(String templateString, Map<String, Object> values) throws MalformedUriTemplateException, VariableExpansionException {
        UriTemplate t = new UriTemplate(templateString);
        t.set(values);
        return t.expand();
    }

    public String expand(Map<String, Object> vars) throws VariableExpansionException {
        this.values = vars;
        return this.expand();
    }

    public String expand() throws VariableExpansionException {
        String template = this.getTemplate();
        for (Expression expression : this.expressions) {
            String replacement = this.expressionReplacementString(expression);
            template = template.replaceAll(expression.getReplacementPattern(), replacement);
        }
        return template;
    }

    public String getTemplate() {
        return this.template;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public UriTemplate withDefaultDateFormat(String dateFormatString) {
        return this.withDefaultDateFormat(new SimpleDateFormat(dateFormatString));
    }

    public UriTemplate withDefaultDateFormat(DateFormat dateFormat) {
        this.defaultDateFormat = dateFormat;
        return this;
    }

    public UriTemplate set(String variableName, Object value) {
        this.values.put(variableName, value);
        return this;
    }

    public boolean hasVariable(String variableName) {
        return this.values.containsKey(variableName);
    }

    public Object get(String variableName) {
        return this.values.get(variableName);
    }

    public UriTemplate set(String variableName, Date value) {
        this.values.put(variableName, value);
        return this;
    }

    public UriTemplate set(Map<String, Object> values) {
        if (values != null && !values.isEmpty()) {
            this.values.putAll(values);
        }
        return this;
    }

    public static boolean containsOperator(String op) {
        return OPERATOR_BITSET.get(op.toCharArray()[0]);
    }

    private String expressionReplacementString(Expression expression) throws VariableExpansionException {
        Operator operator = expression.getOperator();
        List<String> replacements = this.expandVariables(expression);
        String result = this.joinParts(operator.getSeparator(), replacements);
        if (result != null) {
            if (operator != Operator.RESERVED) {
                result = operator.getPrefix() + result;
            }
        } else {
            result = "";
        }
        return result;
    }

    private List<String> expandVariables(Expression expression) throws VariableExpansionException {
        ArrayList<String> replacements = new ArrayList<String>();
        Operator operator = expression.getOperator();
        for (VarSpec varSpec : expression.getVarSpecs()) {
            boolean explodable;
            if (!this.values.containsKey(varSpec.getVariableName())) continue;
            Object value = this.values.get(varSpec.getVariableName());
            String expanded = null;
            if (value != null && value.getClass().isArray()) {
                if (value instanceof char[][]) {
                    char[][] chars = (char[][])value;
                    ArrayList<String> strings = new ArrayList<String>();
                    for (char[] c : chars) {
                        strings.add(String.valueOf(c));
                    }
                    value = strings;
                } else {
                    value = value instanceof char[] ? String.valueOf((char[])value) : this.arrayToList(value);
                }
            }
            if ((explodable = this.isExplodable(value)) && varSpec.getModifier() == Modifier.PREFIX) {
                throw new VariableExpansionException("Prefix modifiers are not applicable to variables that have composite values.");
            }
            if (explodable) {
                VarExploder exploder = value instanceof VarExploder ? (VarExploder)value : VarExploderFactory.getExploder(value, varSpec);
                if (varSpec.getModifier() == Modifier.EXPLODE) {
                    expanded = this.expandMap(operator, varSpec, exploder.getNameValuePairs());
                } else if (varSpec.getModifier() != Modifier.EXPLODE) {
                    expanded = this.expandCollection(operator, varSpec, exploder.getValues());
                }
            }
            if (value instanceof Date) {
                value = this.defaultDateFormat.format((Date)value);
            }
            if (value instanceof Collection) {
                expanded = this.expandCollection(operator, varSpec, (Collection)value);
            } else if (value instanceof Map) {
                expanded = this.expandMap(operator, varSpec, (Map)value);
            } else if (value == null) {
                expanded = null;
            } else if (expanded == null) {
                expanded = this.expandStringValue(operator, varSpec, value.toString(), VarSpec.VarFormat.SINGLE);
            }
            if (expanded == null) continue;
            replacements.add(expanded);
        }
        return replacements;
    }

    private boolean isExplodable(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Collection || value instanceof Map || value.getClass().isArray()) {
            return true;
        }
        return !this.isSimpleType(value);
    }

    private boolean isSimpleType(Object value) {
        return value.getClass().isPrimitive() || value instanceof Number || value instanceof CharSequence || value instanceof Date || value instanceof Boolean;
    }

    private String expandCollection(Operator operator, VarSpec varSpec, Collection<?> variable) throws VariableExpansionException {
        if (variable == null || variable.isEmpty()) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        Iterator<?> i = variable.iterator();
        String separator = operator.getSeparator();
        if (varSpec.getModifier() != Modifier.EXPLODE) {
            separator = operator.getListSeparator();
        }
        while (i.hasNext()) {
            Object obj = i.next();
            this.checkValue(obj);
            String value = obj.toString();
            stringValues.add(this.expandStringValue(operator, varSpec, value, VarSpec.VarFormat.ARRAY));
        }
        if (varSpec.getModifier() != Modifier.EXPLODE && operator.useVarNameWhenExploded()) {
            String parts = this.joinParts(separator, stringValues);
            if (operator == Operator.QUERY && parts == null) {
                return varSpec.getVariableName() + "=";
            }
            return varSpec.getVariableName() + "=" + parts;
        }
        return this.joinParts(separator, stringValues);
    }

    private void checkValue(Object obj) throws VariableExpansionException {
        if (obj instanceof Collection || obj instanceof Map || obj.getClass().isArray()) {
            throw new VariableExpansionException("Nested data structures are not supported.");
        }
    }

    private String expandMap(Operator operator, VarSpec varSpec, Map<String, Object> variable) throws VariableExpansionException {
        if (variable == null || variable.isEmpty()) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        String pairJoiner = "=";
        if (varSpec.getModifier() != Modifier.EXPLODE) {
            pairJoiner = DEFAULT_SEPARATOR;
        }
        String joiner = operator.getSeparator();
        if (varSpec.getModifier() != Modifier.EXPLODE) {
            joiner = operator.getListSeparator();
        }
        for (Map.Entry<String, Object> entry : variable.entrySet()) {
            String key = entry.getKey();
            this.checkValue(entry.getValue());
            String pair = this.expandStringValue(operator, varSpec, key, VarSpec.VarFormat.PAIRS) + pairJoiner + this.expandStringValue(operator, varSpec, entry.getValue().toString(), VarSpec.VarFormat.PAIRS);
            stringValues.add(pair);
        }
        if (varSpec.getModifier() != Modifier.EXPLODE && (operator == Operator.MATRIX || operator == Operator.QUERY || operator == Operator.CONTINUATION)) {
            String joinedValues = this.joinParts(joiner, stringValues);
            if (operator == Operator.QUERY && joinedValues == null) {
                return varSpec.getVariableName() + "=";
            }
            return varSpec.getVariableName() + "=" + joinedValues;
        }
        return this.joinParts(joiner, stringValues);
    }

    private String expandStringValue(Operator operator, VarSpec varSpec, String variable, VarSpec.VarFormat format) throws VariableExpansionException {
        String expanded;
        int position;
        if (varSpec.getModifier() == Modifier.PREFIX && (position = varSpec.getPosition().intValue()) < variable.length()) {
            variable = variable.substring(0, position);
        }
        try {
            expanded = operator.getEncoding() == Encoding.UR ? UriUtil.encodeFragment(variable) : UriUtil.encode(variable);
        }
        catch (UnsupportedEncodingException e) {
            throw new VariableExpansionException("Could not expand variable due to a problem URI encoding the value.", e);
        }
        if (operator.isNamed()) {
            if (expanded.isEmpty() && !operator.getSeparator().equals("&")) {
                expanded = varSpec.getValue();
            } else if (format == VarSpec.VarFormat.SINGLE) {
                expanded = varSpec.getVariableName() + "=" + expanded;
            } else if (varSpec.getModifier() == Modifier.EXPLODE && operator.useVarNameWhenExploded() && format != VarSpec.VarFormat.PAIRS) {
                expanded = varSpec.getVariableName() + "=" + expanded;
            }
        }
        return expanded;
    }

    private String joinParts(String joiner, List<String> parts) {
        if (parts.size() == 0) {
            return null;
        }
        if (parts.size() == 1) {
            return parts.get(0);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            String part = parts.get(i);
            if (part.isEmpty()) continue;
            builder.append(part);
            if (parts.size() <= 0 || i == parts.size() - 1) continue;
            builder.append(joiner);
        }
        return builder.toString();
    }

    private List<Object> arrayToList(Object array) throws VariableExpansionException {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (element.getClass().isArray()) {
                throw new VariableExpansionException("Multi-dimenesional arrays are not supported.");
            }
            list.add(element);
        }
        return list;
    }

    static {
        for (int i = 0; i < OPERATORS.length; ++i) {
            OPERATOR_BITSET.set(OPERATORS[i]);
        }
    }

    public static enum Encoding {
        U,
        UR;

    }
}

