/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.legacy.property;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.google.common.base.Objects;

public class Property {
    private final String name;
    private final String value;
    private final String contextCode;
    private final String application;
    private final long fetchInstant;

    public Property(@Nonnull @NotEmpty String propertyName, @Nonnull @NotEmpty String propertyValue, @Nonnull @NotEmpty String context, long fetched) {
        this(propertyName, propertyValue, context, null, fetched);
    }

    public Property(@Nonnull @NotEmpty String propertyName, @Nonnull @NotEmpty String propertyValue, @Nonnull @NotEmpty String context, String app, long fetched) {
        this.name = propertyName;
        this.value = propertyValue;
        this.contextCode = context;
        this.application = app;
        this.fetchInstant = fetched;
    }

    @Nonnull
    @NotEmpty
    public String getPropertyName() {
        return this.name;
    }

    @Nonnull
    @NotEmpty
    public String getPropertyValue() {
        return this.value;
    }

    @Nonnull
    @NotEmpty
    public String getContextCode() {
        return this.contextCode;
    }

    @Nullable
    public String getApplication() {
        return this.application;
    }

    public long getFetchInstant() {
        return this.fetchInstant;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("value", (Object)this.value).add("context", (Object)this.contextCode).add("application", (Object)this.application).add("fetched", this.fetchInstant).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.value, this.contextCode, this.application, this.fetchInstant});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property that = (Property)obj;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.contextCode, (Object)that.contextCode);
    }
}

