/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.organization.core.organization.io.json;

import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.jsonp.AbstractRealmScopedResourceReader;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.platform.legacy.address.Address;
import com.covisint.platform.legacy.phone.Phones;
import com.covisint.platform.organization.core.organization.Organization;
import com.covisint.platform.organization.core.organization.Status;
import com.covisint.platform.organization.core.organization.io.json.SupportedMediaType;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.net.MediaType;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationReader
extends AbstractRealmScopedResourceReader<Organization> {
    private final Logger log = LoggerFactory.getLogger(OrganizationReader.class);

    private void readPhones(@Nullable JsonArray phones, @Nonnull Organization organization) {
        if (phones == null || phones.isEmpty()) {
            return;
        }
        organization.setPhones(new Phones());
        for (int i = 0; i < phones.size(); ++i) {
            JsonObject phone = phones.getJsonObject(i);
            JsonString typeJsonString = phone.getJsonString("type");
            JsonString numberJsonString = phone.getJsonString("number");
            String type = null;
            if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)typeJsonString)) {
                type = typeJsonString.getString().toLowerCase();
            }
            String number = null;
            if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)numberJsonString)) {
                number = numberJsonString.getString();
            }
            organization.getPhones().setByType(type, number);
        }
    }

    private void readStreets(@Nonnull Address address, @Nullable JsonArray src) {
        if (src == null || src.isEmpty()) {
            return;
        }
        int ct = src.size();
        address.setAddress1(src.getString(0));
        if (ct > 1) {
            address.setAddress2(src.getString(1));
        }
        if (ct > 2) {
            address.setAddress3(src.getString(2));
        }
        if (ct > 3) {
            this.log.warn("Maximum allowed street addresses is 3.");
        }
    }

    private void readAddresses(@Nonnull Organization organization, @Nullable JsonArray addressesJson) {
        if (addressesJson == null || addressesJson.isEmpty()) {
            return;
        }
        for (int i = 0; i < addressesJson.size(); ++i) {
            JsonObject addressJson = addressesJson.getJsonObject(i);
            Address address = this.readAddress(addressJson);
            if (address == null) continue;
            organization.setAddress(address);
            break;
        }
    }

    @Nullable
    private Address readAddress(@Nullable JsonObject src) {
        if (src == null) {
            return null;
        }
        Address address = new Address();
        this.readStreets(address, src.getJsonArray("streets"));
        JsonString stringProperty = src.getJsonString("city");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)stringProperty)) {
            address.setCity(stringProperty.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = src.getJsonString("state")))) {
            address.setState(stringProperty.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = src.getJsonString("postal")))) {
            address.setPostal(stringProperty.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(stringProperty = src.getJsonString("country")))) {
            try {
                address.setCountry(stringProperty.getString());
            }
            catch (IllegalArgumentException e) {
                this.log.warn("country code {} is not an ISO 3166 country code..so skipping it.", (Object)stringProperty.getString());
            }
        }
        return address;
    }

    private void readResourceReferenceFields(@Nonnull JsonObject json, @Nonnull Organization organization) {
        ResourceReference resourceReference = OrganizationReader.readResourceReference((JsonObject)json.getJsonObject("parentOrganization"));
        if (resourceReference != null) {
            organization.setParentOrganization(resourceReference);
        }
        if ((resourceReference = OrganizationReader.readResourceReference((JsonObject)json.getJsonObject("rootOrganization"))) != null) {
            organization.setRootOrganization(resourceReference);
        }
        if ((resourceReference = OrganizationReader.readResourceReference((JsonObject)json.getJsonObject("passwordPolicy"))) != null) {
            organization.setPasswordPolicy(resourceReference);
        }
        if ((resourceReference = OrganizationReader.readResourceReference((JsonObject)json.getJsonObject("authenticationPolicy"))) != null) {
            organization.setAuthenticationPolicy(resourceReference);
        }
    }

    private void readStatus(@Nonnull JsonObject json, @Nonnull Organization organization) {
        JsonString jsonString = json.getJsonString("status");
        if (jsonString != null) {
            Optional status = Enums.getIfPresent(Status.class, (String)jsonString.getString().toUpperCase());
            if (status.isPresent()) {
                organization.setStatus((Status)((Object)status.get()));
            } else {
                this.log.warn("Invalid status value {} found...skipping status", (Object)jsonString);
            }
        }
    }

    @Nonnull
    protected final Organization createResource(@Nonnull MediaType mediaType) {
        return new Organization();
    }

    @Nonnull
    public final Class<Organization> getResourceType() {
        return Organization.class;
    }

    public final boolean isReadable(@Nonnull MediaType mediaType) {
        return SupportedMediaType.ORGANIZATION_MT.value().equals(mediaType.withoutParameters().toString());
    }

    @Nonnull
    public final Organization readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        Organization organization = (Organization)super.readResource(mediaType, json);
        JsonString jsonString = json.getJsonString("name");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)jsonString)) {
            organization.setName(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("email")))) {
            organization.setEmail(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("url")))) {
            organization.setUrl(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("authDomain")))) {
            organization.setAuthDomain(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("organizationType")))) {
            organization.setOrganizationType(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("organizationSubtype")))) {
            organization.setOrganizationSubtype(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("accountNumber")))) {
            organization.setAccountNumber(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("externalCode")))) {
            organization.setExternalCode(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("duns")))) {
            organization.setDuns(jsonString.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull((JsonString)(jsonString = json.getJsonString("classification")))) {
            organization.setClassification(jsonString.getString());
        }
        boolean isPublic = json.getBoolean("public", true);
        organization.setPublicOrganization(isPublic);
        this.readResourceReferenceFields(json, organization);
        JsonArray jsonArray = json.getJsonArray("addresses");
        this.readAddresses(organization, jsonArray);
        jsonArray = json.getJsonArray("phones");
        this.readPhones(jsonArray, organization);
        this.readStatus(json, organization);
        return organization;
    }
}

