/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.platform.organization.client.sdk;

import com.covisint.core.http.service.core.NamedResourceReference;
import com.covisint.core.http.service.core.Page;
import com.covisint.core.http.service.core.Resource;
import com.covisint.core.http.service.core.ResourceReferenceNode;
import com.covisint.core.http.service.core.ServiceException;
import com.covisint.core.http.service.core.SortCriteria;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.httpclient.HttpClientBuilder;
import com.covisint.core.support.primitive.StringSupport;
import com.covisint.platform.oauth.client.token.sdk.AuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.DefaultAuthConfigurationProvider;
import com.covisint.platform.oauth.client.token.sdk.TokenSupplier;
import com.covisint.platform.organization.client.organization.OrganizationClientFactory;
import com.covisint.platform.organization.client.organization.OrganizationClientImpl;
import com.covisint.platform.organization.core.organization.Organization;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class OrganizationSDK
extends OrganizationClientFactory {
    private AuthConfigurationProvider authConfigProvider;

    public OrganizationSDK(@Nonnull @NotEmpty String serviceUrl) {
        super(serviceUrl);
    }

    @Nonnull
    protected AuthConfigurationProvider getAuthConfigProvider() {
        if (this.authConfigProvider == null) {
            this.authConfigProvider = new DefaultAuthConfigurationProvider();
        }
        return this.authConfigProvider;
    }

    protected HttpClientBuilder populateHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        TokenSupplier tokenSupplier = new TokenSupplier(this.getAuthConfigProvider());
        builder.addAuthorizationTokenInterceptor((Supplier)tokenSupplier);
        return builder;
    }

    public OrganizationSDK setAuthConfigProvider(@Nonnull AuthConfigurationProvider provider) {
        this.authConfigProvider = provider;
        return this;
    }

    public OrganizationClientImpl create() {
        throw new UnsupportedOperationException("Please use #newClient to create new client instances.");
    }

    @Nonnull
    public OrganizationClient newClient() {
        return new ClientImpl((OrganizationClientImpl)super.create());
    }

    private static final class ClientImpl
    implements OrganizationClient {
        private final OrganizationClientImpl delegate;

        private ClientImpl(@Nonnull OrganizationClientImpl newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        @Nonnull
        public CheckedFuture<Organization, ServiceException> get(@Nonnull @NotEmpty String organizationId) {
            return this.delegate.get(organizationId, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Organization, ServiceException> add(@Nonnull Organization organization) {
            return this.delegate.add((Resource)organization, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<Organization, ServiceException> update(@Nonnull Organization organization) {
            return this.delegate.persist((Resource)organization, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<List<Organization>, ServiceException> search(List<String> name, String parentOrganizationId, String rootOrganizationId, @Nonnull Page page) {
            ArrayListMultimap filter = ArrayListMultimap.create();
            if (name != null && !name.isEmpty()) {
                filter.putAll((Object)"name", name);
            }
            if (StringSupport.trimOrNull((String)parentOrganizationId) != null) {
                filter.put((Object)"parentOrganization", (Object)parentOrganizationId);
            }
            if (StringSupport.trimOrNull((String)rootOrganizationId) != null) {
                filter.put((Object)"rootOrganization", (Object)rootOrganizationId);
            }
            return this.delegate.search((Multimap)filter, SortCriteria.NONE, page, (HttpContext)new BasicHttpContext());
        }

        @Override
        @Nonnull
        public CheckedFuture<ResourceReferenceNode<NamedResourceReference>, ServiceException> getHierarchy(@Nonnull @NotEmpty String organizationId) {
            return this.delegate.getHierarchy(organizationId, (HttpContext)new BasicHttpContext());
        }
    }

    public static interface OrganizationClient {
        @Nonnull
        public CheckedFuture<Organization, ServiceException> add(@Nonnull Organization var1);

        @Nonnull
        public CheckedFuture<Organization, ServiceException> update(@Nonnull Organization var1);

        @Nonnull
        public CheckedFuture<Organization, ServiceException> get(@Nonnull @NotEmpty String var1);

        @Nonnull
        public CheckedFuture<List<Organization>, ServiceException> search(List<String> var1, String var2, String var3, @Nonnull Page var4);

        @Nonnull
        public CheckedFuture<ResourceReferenceNode<NamedResourceReference>, ServiceException> getHierarchy(@Nonnull @NotEmpty String var1);
    }
}

