/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.support.aspect;

import java.util.Collection;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public final class NonnullElementsValidator {
    private static final String METHOD_ARG_EMPTY_MESSAGE = "Method arg at index %d failed constraint @NonnullElements.";
    private static final String CONSTRUCTOR_ARG_EMPTY_MESSAGE = "Constructor arg at index %d failed constraint @NonNullElements";
    private static final String METHOD_RETURN_EMPTY_MESSAGE = "Method return value failed constraint @NonnullElements.";
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ NonnullElementsValidator ajc$perSingletonInstance;

    private static void assertNonNullElements(String messageTemplate, Integer paramIndex, Object object, JoinPoint joinPoint) {
        if (!(object instanceof Collection)) {
            return;
        }
        StringBuilder message = paramIndex != null ? new StringBuilder(String.format(messageTemplate, paramIndex)) : new StringBuilder(messageTemplate);
        for (Object o : (Collection)object) {
            if (o != null) continue;
            String ls = System.lineSeparator();
            message.append(ls).append("Method: ").append(joinPoint.getSignature().toLongString()).append(ls);
            if (joinPoint.getSourceLocation() != null) {
                message.append("Line: ").append(joinPoint.getSourceLocation().getLine());
            }
            throw new IllegalArgumentException(message.toString());
        }
    }

    @Before(value="execution(* *(@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(value,..)")
    public void validateMethodArg1(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(METHOD_ARG_EMPTY_MESSAGE, 1, value, joinPoint);
    }

    @Before(value="execution(* *(*,@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(*,value,..)")
    public void validateMethodArg2(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(METHOD_ARG_EMPTY_MESSAGE, 2, value, joinPoint);
    }

    @Before(value="execution(* *(*,*,@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(*,*,value,..)")
    public void validateMethodArg3(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(METHOD_ARG_EMPTY_MESSAGE, 3, value, joinPoint);
    }

    @Before(value="execution(* *(*,*,*,@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(*,*,*,value,..)")
    public void validateMethodArg4(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(METHOD_ARG_EMPTY_MESSAGE, 4, value, joinPoint);
    }

    @Before(value="execution(* *(*,*,*,*,@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(*,*,*,*,value,..)")
    public void validateMethodArg5(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(METHOD_ARG_EMPTY_MESSAGE, 5, value, joinPoint);
    }

    @Before(value="execution(new(@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(value)")
    public void validateConstructorArg1(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 1, value, joinPoint);
    }

    @Before(value="execution(new(*,@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(*,value)")
    public void validateConstructorArg2(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 2, value, joinPoint);
    }

    @Before(value="execution(new(*,*,@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(*,*,value)")
    public void validateConstructorArg3(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 3, value, joinPoint);
    }

    @Before(value="execution(new(*,*,*,@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(*,*,*,value)")
    public void validateConstructorArg4(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 4, value, joinPoint);
    }

    @Before(value="execution(new(*,*,*,*,@com.covisint.core.support.constraint.NonnullElements (*),..)) && args(*,*,*,*,value)")
    public void validateConstructorArg5(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(CONSTRUCTOR_ARG_EMPTY_MESSAGE, 5, value, joinPoint);
    }

    @AfterReturning(pointcut="execution(@com.covisint.core.support.constraint.NonnullElements * *(..))", returning="value")
    public void validateMethodReturnValue(Object value, JoinPoint joinPoint) {
        NonnullElementsValidator.assertNonNullElements(METHOD_RETURN_EMPTY_MESSAGE, null, value, joinPoint);
    }

    public static NonnullElementsValidator aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.covisint.core.support.aspect.NonnullElementsValidator", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            NonnullElementsValidator.ajc$perSingletonInstance = new NonnullElementsValidator();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

