/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core;

import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NotEmpty;
import com.covisint.core.support.constraint.Nullable;
import com.google.common.base.Objects;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvocationContext
implements Serializable {
    private static final long serialVersionUID = -2999965137985886290L;
    private static Logger log = LoggerFactory.getLogger(InvocationContext.class);
    private static final ThreadLocal<InvocationContext> THREADLOCAL = new InheritableThreadLocal<InvocationContext>(){

        @Override
        protected InvocationContext initialValue() {
            return new InvocationContext();
        }
    };
    private long traceId;
    private long spanId;
    private long parentSpanId;
    private String realmId;
    private String requestor;
    private String requestorId;
    private String requestorApplicationId;
    private String requestorType;

    private InvocationContext() {
    }

    @Nullable
    public static long getTraceId() {
        return InvocationContext.get().traceId;
    }

    public static void setTraceId(long newTraceId) {
        InvocationContext.get().traceId = newTraceId;
    }

    public static long getSpanId() {
        return InvocationContext.get().spanId;
    }

    public static void setSpanId(long newSpanId) {
        InvocationContext.get().spanId = newSpanId;
    }

    public static long getParentSpanId() {
        return InvocationContext.get().parentSpanId;
    }

    public static void setParentSpanId(long newParentSpanId) {
        InvocationContext.get().parentSpanId = newParentSpanId;
    }

    @Nullable
    public static String getRealmId() {
        return InvocationContext.get().realmId;
    }

    public static void setRealmId(@Nonnull @NotEmpty String newRealmId) {
        InvocationContext.get().realmId = newRealmId;
    }

    @Nullable
    public static String getRequestor() {
        return InvocationContext.get().requestor;
    }

    public static void setRequestor(@Nonnull @NotEmpty String newRequestor) {
        InvocationContext.get().requestor = newRequestor;
    }

    @Nullable
    public static String getRequestorId() {
        return InvocationContext.get().requestorId;
    }

    public static void setRequestorId(@Nonnull @NotEmpty String newRequestorId) {
        InvocationContext.get().requestorId = newRequestorId;
    }

    @Nullable
    public static String getRequestorApplicationId() {
        return InvocationContext.get().requestorApplicationId;
    }

    public static void setRequestorApplicationId(@Nonnull @NotEmpty String newRequestorApplicationId) {
        InvocationContext.get().requestorApplicationId = newRequestorApplicationId;
    }

    @Nullable
    public static String getRequestorType() {
        return InvocationContext.get().requestorType;
    }

    public static void setRequestorType(@Nonnull @NotEmpty String newRequestorType) {
        InvocationContext.get().requestorType = newRequestorType;
    }

    public static void set(@Nonnull InvocationContext invocationContext) {
        THREADLOCAL.set(invocationContext);
        log.debug("Set invocation context on thread local: {}", (Object)invocationContext);
    }

    public static void clear() {
        InvocationContext invocationContext = InvocationContext.get();
        if (invocationContext != null) {
            log.debug("Clear invocation context on thread local: {}", (Object)invocationContext);
            THREADLOCAL.remove();
        }
    }

    public static InvocationContext get() {
        return THREADLOCAL.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvocationContext)) {
            return false;
        }
        InvocationContext that = (InvocationContext)obj;
        return this.traceId == that.traceId && this.spanId == that.spanId && this.parentSpanId == that.parentSpanId && this.realmId.equals(that.realmId) && this.requestor.equals(that.requestor) && this.requestorId.equals(that.requestorId) && this.requestorApplicationId.equals(that.requestorApplicationId) && this.requestorType.equals(that.requestorType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.traceId, this.spanId, this.parentSpanId, this.realmId, this.requestor, this.requestorId, this.requestorApplicationId, this.requestorType});
    }

    @Nonnull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("traceId", this.traceId).add("spanId", this.spanId).add("parentSpanId", this.parentSpanId).add("realmId", (Object)this.realmId).add("requestor", (Object)this.requestor).add("requestorId", (Object)this.requestorId).add("requestorApplicationId", (Object)this.requestorApplicationId).add("requestorType", (Object)this.requestorType).toString();
    }
}

