/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core.io.jsonp;

import com.covisint.core.http.service.core.AbstractResource;
import com.covisint.core.http.service.core.ResourceReference;
import com.covisint.core.http.service.core.io.EntityParsingException;
import com.covisint.core.http.service.core.io.EntityReader;
import com.covisint.core.http.service.core.io.EntityReaderException;
import com.covisint.core.http.service.core.io.jsonp.JsonpSupport;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.NonnullElements;
import com.covisint.core.support.constraint.Nullable;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceReader<T extends AbstractResource>
implements EntityReader {
    private final Logger log = LoggerFactory.getLogger(AbstractResourceReader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object read(@Nonnull MediaType mediaType, @Nonnull InputStream input) {
        this.log.debug("Preparing to parse JSON data from inputstream");
        try (JsonReader jsonReader = Json.createReader((InputStream)input);){
            JsonStructure json = jsonReader.read();
            this.log.debug("Parsed a JSON structure of type {}", (Object)json.getValueType().toString());
            if (JsonpSupport.isArray((JsonValue)json)) {
                List<T> list = this.readResourceArray(mediaType, (JsonArray)json);
                return list;
            }
            if (JsonpSupport.isObject((JsonValue)json)) {
                T t = this.readResource(mediaType, (JsonObject)json);
                return t;
            }
            this.log.debug("Root-level JSON structure of type {} is not supported by this reader", (Object)json.getValueType().toString());
            throw new EntityReaderException("Root-level JSON structure of " + json.getValueType().toString() + " is not supported.");
        }
        catch (JsonParsingException e) {
            this.log.debug("Invalid JSON, unable to parse", (Throwable)e);
            throw new EntityParsingException(e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), (Throwable)e);
        }
        catch (JsonException e) {
            try (Scanner scanner = new Scanner(input);){
                if (!scanner.hasNext()) {
                    T t = this.createResource(mediaType);
                    return t;
                }
            }
            this.log.debug("Unable to parse JSON", (Throwable)e);
            throw new EntityReaderException("Unable to parse JSON");
        }
        catch (ClassCastException | IllegalStateException e) {
            this.log.debug("Unable to parse JSON", (Throwable)e);
            throw new EntityReaderException("Unable to parse JSON");
        }
    }

    @Nonnull
    protected abstract T createResource(@Nonnull MediaType var1);

    @Nonnull
    @NonnullElements
    protected List<T> readResourceArray(@Nonnull MediaType mediaType, @Nonnull JsonArray jsonArray) {
        ArrayList<T> resources = new ArrayList<T>();
        for (JsonValue jsonElement : jsonArray) {
            if (JsonpSupport.isObject(jsonElement)) {
                resources.add(this.readResource(mediaType, (JsonObject)jsonElement));
                continue;
            }
            if (JsonpSupport.isNull(jsonElement)) {
                this.log.debug("JSON array contained a null element, ignoring it");
                continue;
            }
            this.log.debug("{} JSON structure is not supported within the root-level array", (Object)jsonElement.getValueType().toString());
            throw new EntityReaderException(jsonElement.getValueType().toString() + " JSON structure of is not supported in root-level array.");
        }
        return resources;
    }

    protected T readResource(@Nonnull MediaType mediaType, @Nonnull JsonObject json) {
        T resource = this.createResource(mediaType);
        this.log.debug("Created a resource of type {} into which the JSON data will be read", (Object)resource.getClass().getName());
        this.populateAbstractResourceData(mediaType, json, resource);
        return resource;
    }

    protected void populateAbstractResourceData(@Nonnull MediaType mediaType, @Nonnull JsonObject json, @Nonnull T resource) {
        JsonNumber numberValue;
        JsonString stringValue = json.getJsonString("id");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull(stringValue)) {
            ((AbstractResource)resource).setId(stringValue.getString());
        }
        if ((numberValue = json.getJsonNumber("version")) != null) {
            ((AbstractResource)resource).setVersion(numberValue.longValue());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull(stringValue = json.getJsonString("creator"))) {
            ((AbstractResource)resource).setCreator(stringValue.getString());
        }
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull(stringValue = json.getJsonString("creatorAppId"))) {
            ((AbstractResource)resource).setCreatorApplicationId(stringValue.getString());
        }
        if ((numberValue = json.getJsonNumber("creation")) != null) {
            ((AbstractResource)resource).setCreationInstant(numberValue.longValue());
        }
    }

    @Nullable
    protected static final ResourceReference readResourceReference(@Nullable JsonObject json) {
        if (json == null) {
            return null;
        }
        JsonString jsonString = json.getJsonString("id");
        if (JsonpSupport.isJsonStringPropertyEmptyOrNull(jsonString)) {
            return null;
        }
        String resourceId = jsonString.getString();
        String resourceType = null;
        jsonString = json.getJsonString("type");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull(jsonString)) {
            resourceType = jsonString.getString();
        }
        String resourceRealm = null;
        jsonString = json.getJsonString("realm");
        if (!JsonpSupport.isJsonStringPropertyEmptyOrNull(jsonString)) {
            resourceRealm = jsonString.getString();
        }
        return new ResourceReference(resourceId, resourceType, resourceRealm);
    }
}

