/*
 * Decompiled with CFR 0.152.
 */
package com.covisint.core.http.service.core;

import com.covisint.core.support.constraint.Constraints;
import com.covisint.core.support.constraint.Nonnull;
import com.covisint.core.support.constraint.Nullable;
import com.covisint.core.support.primitive.StringSupport;

public class HttpServiceError {
    private final int httpStatusCode;
    private final String apiStatusCode;
    private final String message;

    public HttpServiceError(int httpStatus, @Nullable String apiStatus, @Nullable String apiMessage) {
        Constraints.isGreaterThanOrEqual((long)100L, (long)httpStatus, (String)"HTTP status code must be 100 or greater.");
        Constraints.isLessThanOrEqual((long)599L, (long)httpStatus, (String)"HTTP Status code must be 599 or less");
        this.httpStatusCode = httpStatus;
        this.apiStatusCode = StringSupport.trimOrEmpty((String)apiStatus);
        this.message = StringSupport.trimOrEmpty((String)apiMessage);
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Nonnull
    public String getApiStatusCode() {
        return this.apiStatusCode;
    }

    @Nonnull
    public String getApiMessage() {
        return this.message;
    }
}

